/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.UpdateMemory;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash.GroupByHash;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.column.BooleanColumn;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.read.common.type.Type;

public class MarkDistinctHash {
    private final GroupByHash groupByHash;
    private long nextDistinctId;

    public MarkDistinctHash(List<Type> types, boolean hasPrecomputedHash, UpdateMemory updateMemory) {
        this.groupByHash = GroupByHash.createGroupByHash(types, hasPrecomputedHash, 64, updateMemory);
    }

    public long getEstimatedSize() {
        return this.groupByHash.getEstimatedSize() + 8L;
    }

    public Column markDistinctRows(Column[] columns) {
        Preconditions.checkArgument((columns.length > 0 ? 1 : 0) != 0, (Object)"columns shouldn't be empty here");
        int[] groupIds = this.groupByHash.getGroupIds(columns);
        return this.processNextGroupIds(this.groupByHash.getGroupCount(), groupIds, columns[0].getPositionCount());
    }

    @VisibleForTesting
    public int getCapacity() {
        return this.groupByHash.getCapacity();
    }

    private Column processNextGroupIds(int groupCount, int[] ids, int positions) {
        if (positions > 1) {
            if (this.nextDistinctId == (long)groupCount) {
                return new RunLengthEncodedColumn((Column)new BooleanColumn(1, Optional.empty(), new boolean[]{false}), positions);
            }
            if (this.nextDistinctId + (long)positions == (long)groupCount) {
                this.nextDistinctId = groupCount;
                return new RunLengthEncodedColumn((Column)new BooleanColumn(1, Optional.empty(), new boolean[]{true}), positions);
            }
        }
        boolean[] distinctMask = new boolean[positions];
        for (int position = 0; position < distinctMask.length; ++position) {
            if ((long)ids[position] == this.nextDistinctId) {
                distinctMask[position] = true;
                ++this.nextDistinctId;
                continue;
            }
            distinctMask[position] = false;
        }
        Preconditions.checkState((this.nextDistinctId == (long)groupCount ? 1 : 0) != 0);
        return new BooleanColumn(positions, Optional.empty(), distinctMask);
    }
}

