/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.bitpacking;

public class IntPacker {
    private static final int NUM_OF_INTS = 8;
    private int width;

    public IntPacker(int width) {
        this.width = width;
    }

    public void pack8Values(int[] values, int offset, byte[] buf) {
        int bufIdx = 0;
        int valueIdx = offset;
        int leftBit = 0;
        while (valueIdx < 8 + offset) {
            int buffer = 0;
            int leftSize = 32;
            if (leftBit > 0) {
                buffer |= values[valueIdx] << 32 - leftBit;
                leftSize -= leftBit;
                leftBit = 0;
                ++valueIdx;
            }
            while (leftSize >= this.width && valueIdx < 8 + offset) {
                buffer |= values[valueIdx] << leftSize - this.width;
                leftSize -= this.width;
                ++valueIdx;
            }
            if (leftSize > 0 && valueIdx < 8 + offset) {
                buffer |= values[valueIdx] >>> this.width - leftSize;
                leftBit = this.width - leftSize;
            }
            for (int j = 0; j < 4; ++j) {
                buf[bufIdx] = (byte)(buffer >>> (3 - j) * 8 & 0xFF);
                if (++bufIdx < this.width) continue;
                return;
            }
        }
    }

    public void unpack8Values(byte[] buf, int offset, int[] values) {
        int byteIdx = offset;
        long buffer = 0L;
        int totalBits = 0;
        int valueIdx = 0;
        while (valueIdx < 8) {
            while (totalBits < this.width) {
                buffer = buffer << 8 | (long)(buf[byteIdx] & 0xFF);
                ++byteIdx;
                totalBits += 8;
            }
            while (totalBits >= this.width && valueIdx < 8) {
                values[valueIdx] = (int)(buffer >>> totalBits - this.width);
                ++valueIdx;
                buffer &= (long)((1 << (totalBits -= this.width)) - 1);
            }
        }
    }

    public void unpackAllValues(byte[] buf, int length, int[] values) {
        int idx = 0;
        int k = 0;
        while (idx < length) {
            int[] tv = new int[8];
            this.unpack8Values(buf, idx, tv);
            System.arraycopy(tv, 0, values, k, 8);
            idx += this.width;
            k += 8;
        }
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

