/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils;

import java.io.IOException;
import java.util.List;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.reader.IPointReader;
import org.apache.tsfile.read.reader.page.TimePageReader;
import org.apache.tsfile.read.reader.page.ValuePageReader;
import org.apache.tsfile.utils.TsPrimitiveType;

public class BatchedCompactionAlignedPagePointReader
implements IPointReader {
    private final TimePageReader timeReader;
    private final List<ValuePageReader> valueReaders;
    private boolean hasNextRow = false;
    private int timeIndex = -1;
    private long currentTime;
    private TsPrimitiveType currentRow;

    public BatchedCompactionAlignedPagePointReader(TimePageReader timeReader, List<ValuePageReader> valueReaders) throws IOException {
        this.timeReader = timeReader;
        this.valueReaders = valueReaders;
        this.prepareNextRow();
    }

    private void prepareNextRow() throws IOException {
        if (!this.timeReader.hasNextTime()) {
            this.hasNextRow = false;
            return;
        }
        this.currentTime = this.timeReader.nextTime();
        ++this.timeIndex;
        TsPrimitiveType[] valuesInThisRow = new TsPrimitiveType[this.valueReaders.size()];
        for (int i = 0; i < this.valueReaders.size(); ++i) {
            TsPrimitiveType value;
            valuesInThisRow[i] = value = this.valueReaders.get(i) == null ? null : this.valueReaders.get(i).nextValue(this.currentTime, this.timeIndex);
        }
        this.currentRow = new TsPrimitiveType.TsVector(valuesInThisRow);
        this.hasNextRow = true;
    }

    public boolean hasNextTimeValuePair() throws IOException {
        return this.hasNextRow;
    }

    public TimeValuePair nextTimeValuePair() throws IOException {
        TimeValuePair ret = this.currentTimeValuePair();
        this.prepareNextRow();
        return ret;
    }

    public TimeValuePair currentTimeValuePair() throws IOException {
        return new TimeValuePair(this.currentTime, this.currentRow);
    }

    public long getUsedMemorySize() {
        return 0L;
    }

    public void close() throws IOException {
    }
}

