/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.reporter.iotdb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.isession.pool.SessionDataSetWrapper;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.reporter.iotdb.IoTDBReporter;
import org.apache.iotdb.metrics.type.IMetric;
import org.apache.iotdb.metrics.utils.IoTDBMetricsUtils;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.tsfile.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBSessionReporter
extends IoTDBReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBSessionReporter.class);
    private static final MetricConfig metricConfig = MetricConfigDescriptor.getInstance().getMetricConfig();
    private static final MetricConfig.IoTDBReporterConfig ioTDBReporterConfig = MetricConfigDescriptor.getInstance().getMetricConfig().getIoTDBReporterConfig();
    private Future<?> currentServiceFuture;
    private final ScheduledExecutorService service;
    protected AbstractMetricManager metricManager;
    protected SessionPool sessionPool;

    public IoTDBSessionReporter(AbstractMetricManager metricManager) {
        block16: {
            this.service = Executors.newSingleThreadScheduledExecutor();
            this.metricManager = metricManager;
            this.sessionPool = new SessionPool(ioTDBReporterConfig.getHost(), ioTDBReporterConfig.getPort().intValue(), ioTDBReporterConfig.getUsername(), ioTDBReporterConfig.getPassword(), ioTDBReporterConfig.getMaxConnectionNumber().intValue());
            try (SessionDataSetWrapper result = this.sessionPool.executeQueryStatement("SHOW DATABASES " + metricConfig.getInternalDatabase());){
                if (result.hasNext()) break block16;
                try (SessionDataSetWrapper result2 = this.sessionPool.executeQueryStatement("CREATE DATABASE " + metricConfig.getInternalDatabase() + " WITH SCHEMA_REPLICATION_FACTOR=1, DATA_REPLICATION_FACTOR=1, SCHEMA_REGION_GROUP_NUM=1, DATA_REGION_GROUP_NUM=1");){
                    if (!result2.hasNext()) {
                        LOGGER.error("IoTDBSessionReporter checkOrCreateDatabase failed.");
                    }
                }
            }
            catch (IoTDBConnectionException e) {
                LOGGER.warn("IoTDBSessionReporter checkOrCreateDatabase failed because ", (Throwable)e);
            }
            catch (StatementExecutionException statementExecutionException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean start() {
        if (this.currentServiceFuture != null) {
            LOGGER.warn("IoTDBSessionReporter already start!");
            return false;
        }
        this.currentServiceFuture = this.service.scheduleAtFixedRate(() -> {
            try {
                HashMap<String, Map<String, Object>> values = new HashMap<String, Map<String, Object>>();
                for (Map.Entry<MetricInfo, IMetric> metricEntry : this.metricManager.getAllMetrics().entrySet()) {
                    String prefix = IoTDBMetricsUtils.generatePath(metricEntry.getKey());
                    HashMap<String, Object> value = new HashMap<String, Object>();
                    metricEntry.getValue().constructValueMap(value);
                    values.put(prefix, value);
                }
                this.writeMetricsToIoTDB(values, System.currentTimeMillis());
            }
            catch (Throwable t) {
                LOGGER.error("IoTDBSessionReporter failed to start, because", t);
            }
        }, 1L, MetricConfigDescriptor.getInstance().getMetricConfig().getAsyncCollectPeriodInSecond().intValue(), TimeUnit.SECONDS);
        LOGGER.info("IoTDBSessionReporter start, write to {}:{}", (Object)ioTDBReporterConfig.getHost(), (Object)ioTDBReporterConfig.getPort());
        return true;
    }

    @Override
    public boolean stop() {
        if (this.currentServiceFuture != null) {
            this.currentServiceFuture.cancel(true);
            this.currentServiceFuture = null;
        }
        if (this.sessionPool != null) {
            this.sessionPool.close();
        }
        LOGGER.info("IoTDBSessionReporter stop!");
        return true;
    }

    @Override
    public ReporterType getReporterType() {
        return ReporterType.IOTDB;
    }

    @Override
    protected void writeMetricToIoTDB(Map<String, Object> valueMap, String prefix, long time) {
        ArrayList<String> sensors = new ArrayList<String>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<String, Object> sensor : valueMap.entrySet()) {
            sensors.add(sensor.getKey());
            dataTypes.add(this.inferType(sensor.getValue()));
            values.add(sensor.getValue());
        }
        try {
            this.sessionPool.insertRecord(prefix, time, sensors, dataTypes, values);
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            LOGGER.warn("IoTDBSessionReporter failed to insert record, because ", e);
        }
    }

    @Override
    protected void writeMetricsToIoTDB(Map<String, Map<String, Object>> valueMap, long time) {
        ArrayList<String> deviceIds = new ArrayList<String>();
        ArrayList<Long> times = new ArrayList<Long>();
        ArrayList sensors = new ArrayList();
        ArrayList dataTypes = new ArrayList();
        ArrayList values = new ArrayList();
        for (Map.Entry<String, Map<String, Object>> metric : valueMap.entrySet()) {
            deviceIds.add(metric.getKey());
            times.add(time);
            ArrayList<String> metricSensors = new ArrayList<String>();
            ArrayList<TSDataType> metricDataTypes = new ArrayList<TSDataType>();
            ArrayList<Object> metricValues = new ArrayList<Object>();
            for (Map.Entry<String, Object> sensor : metric.getValue().entrySet()) {
                metricSensors.add(sensor.getKey());
                metricDataTypes.add(this.inferType(sensor.getValue()));
                metricValues.add(sensor.getValue());
            }
            sensors.add(metricSensors);
            dataTypes.add(metricDataTypes);
            values.add(metricValues);
        }
        try {
            this.sessionPool.insertRecords(deviceIds, times, sensors, dataTypes, values);
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            LOGGER.warn("IoTDBSessionReporter failed to insert record, because ", e);
        }
    }
}

