/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.trigger;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class UpdateTriggerLocationPlan
extends ConfigPhysicalPlan {
    private String triggerName;
    private TDataNodeLocation dataNodeLocation;

    public UpdateTriggerLocationPlan() {
        super(ConfigPhysicalPlanType.UpdateTriggerLocation);
    }

    public UpdateTriggerLocationPlan(String triggerName, TDataNodeLocation dataNodeLocation) {
        super(ConfigPhysicalPlanType.UpdateTriggerLocation);
        this.triggerName = triggerName;
        this.dataNodeLocation = dataNodeLocation;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public TDataNodeLocation getDataNodeLocation() {
        return this.dataNodeLocation;
    }

    public void setDataNodeLocation(TDataNodeLocation dataNodeLocation) {
        this.dataNodeLocation = dataNodeLocation;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.triggerName, (OutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.dataNodeLocation, (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.triggerName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.dataNodeLocation = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UpdateTriggerLocationPlan that = (UpdateTriggerLocationPlan)o;
        return Objects.equals(this.triggerName, that.triggerName) && Objects.equals(this.dataNodeLocation, that.dataNodeLocation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.triggerName, this.dataNodeLocation);
    }
}

