/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.pipe.consensuspipe;

import java.util.Objects;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.consensus.common.Peer;

public class ConsensusPipeName {
    private static final String CONSENSUS_PIPE_NAME_SPLITTER_CHAR = "_";
    private final ConsensusGroupId consensusGroupId;
    private final int senderDataNodeId;
    private final int receiverDataNodeId;

    public ConsensusPipeName(Peer senderPeer, Peer receiverPeer) {
        this.consensusGroupId = senderPeer.getGroupId();
        this.senderDataNodeId = senderPeer.getNodeId();
        this.receiverDataNodeId = receiverPeer.getNodeId();
    }

    public ConsensusPipeName(ConsensusGroupId consensusGroupId, int senderDataNodeId, int receiverDataNodeId) {
        this.consensusGroupId = consensusGroupId;
        this.senderDataNodeId = senderDataNodeId;
        this.receiverDataNodeId = receiverDataNodeId;
    }

    public ConsensusPipeName(String pipeName) throws IllegalArgumentException {
        if (!pipeName.startsWith("__consensus.")) {
            throw new IllegalArgumentException("Invalid pipe name: " + pipeName);
        }
        String[] pipeNameParts = pipeName.substring("__consensus.".length()).split(CONSENSUS_PIPE_NAME_SPLITTER_CHAR);
        if (pipeNameParts.length != 3) {
            throw new IllegalArgumentException("Invalid pipe name: " + pipeName);
        }
        this.consensusGroupId = ConsensusGroupId.Factory.createFromString((String)pipeNameParts[0]);
        this.senderDataNodeId = Integer.parseInt(pipeNameParts[1]);
        this.receiverDataNodeId = Integer.parseInt(pipeNameParts[2]);
    }

    public ConsensusGroupId getConsensusGroupId() {
        return this.consensusGroupId;
    }

    public int getSenderDataNodeId() {
        return this.senderDataNodeId;
    }

    public int getReceiverDataNodeId() {
        return this.receiverDataNodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsensusPipeName that = (ConsensusPipeName)o;
        return Objects.equals(this.consensusGroupId, that.consensusGroupId) && Objects.equals(this.senderDataNodeId, that.senderDataNodeId) && Objects.equals(this.receiverDataNodeId, that.receiverDataNodeId);
    }

    public int hashCode() {
        return Objects.hash(this.consensusGroupId, this.senderDataNodeId, this.receiverDataNodeId);
    }

    public String toString() {
        return String.join((CharSequence)CONSENSUS_PIPE_NAME_SPLITTER_CHAR, "__consensus." + this.consensusGroupId, String.valueOf(this.senderDataNodeId), String.valueOf(this.receiverDataNodeId));
    }
}

