/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.snapshot;

import com.google.common.util.concurrent.RateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTConsensusRateLimiter {
    private static final Logger logger = LoggerFactory.getLogger(IoTConsensusRateLimiter.class);
    private final RateLimiter rateLimiter = RateLimiter.create((double)Double.MAX_VALUE);
    private static final IoTConsensusRateLimiter INSTANCE = new IoTConsensusRateLimiter();

    private IoTConsensusRateLimiter() {
    }

    public void init(long regionMigrationSpeedLimitBytesPerSecond) {
        this.rateLimiter.setRate(regionMigrationSpeedLimitBytesPerSecond <= 0L ? Double.MAX_VALUE : (double)regionMigrationSpeedLimitBytesPerSecond);
    }

    public void acquireTransitDataSizeWithRateLimiter(long transitDataSize) {
        while (transitDataSize > 0L) {
            if (transitDataSize > Integer.MAX_VALUE) {
                this.rateLimiter.acquire(Integer.MAX_VALUE);
                transitDataSize -= Integer.MAX_VALUE;
                continue;
            }
            this.rateLimiter.acquire((int)transitDataSize);
            return;
        }
    }

    public static IoTConsensusRateLimiter getInstance() {
        return INSTANCE;
    }
}

