/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.batch;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTabletEventBatch;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBatchReq;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTabletEventPlainBatch
extends PipeTabletEventBatch {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTabletEventPlainBatch.class);
    private final List<ByteBuffer> binaryBuffers = new ArrayList<ByteBuffer>();
    private final List<ByteBuffer> insertNodeBuffers = new ArrayList<ByteBuffer>();
    private final List<ByteBuffer> tabletBuffers = new ArrayList<ByteBuffer>();
    private final PipeMemoryBlock allocatedMemoryBlock;
    private final Map<Pair<String, Long>, Long> pipe2BytesAccumulated = new HashMap<Pair<String, Long>, Long>();

    PipeTabletEventPlainBatch(int maxDelayInMs, long requestMaxBatchSizeInBytes) {
        super(maxDelayInMs);
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().tryAllocate(requestMaxBatchSizeInBytes).setShrinkMethod(oldMemory -> Math.max(oldMemory / 2L, 0L)).setShrinkCallback((oldMemory, newMemory) -> LOGGER.info("The batch size limit has shrunk from {} to {}.", oldMemory, newMemory)).setExpandMethod(oldMemory -> Math.min(Math.max(oldMemory, 1L) * 2L, requestMaxBatchSizeInBytes)).setExpandCallback((oldMemory, newMemory) -> LOGGER.info("The batch size limit has expanded from {} to {}.", oldMemory, newMemory));
        if (this.getMaxBatchSizeInBytes() != requestMaxBatchSizeInBytes) {
            LOGGER.info("PipeTabletEventBatch: the max batch size is adjusted from {} to {} due to the memory restriction", (Object)requestMaxBatchSizeInBytes, (Object)this.getMaxBatchSizeInBytes());
        }
    }

    @Override
    protected boolean constructBatch(TabletInsertionEvent event) throws WALPipeException, IOException {
        int bufferSize = this.buildTabletInsertionBuffer(event);
        this.totalBufferSize += (long)bufferSize;
        this.pipe2BytesAccumulated.compute((Pair<String, Long>)new Pair((Object)((EnrichedEvent)event).getPipeName(), (Object)((EnrichedEvent)event).getCreationTime()), (pipeName, bytesAccumulated) -> bytesAccumulated == null ? (long)bufferSize : bytesAccumulated + (long)bufferSize);
        return true;
    }

    @Override
    public synchronized void onSuccess() {
        super.onSuccess();
        this.binaryBuffers.clear();
        this.insertNodeBuffers.clear();
        this.tabletBuffers.clear();
        this.pipe2BytesAccumulated.clear();
    }

    public PipeTransferTabletBatchReq toTPipeTransferReq() throws IOException {
        return PipeTransferTabletBatchReq.toTPipeTransferReq(this.binaryBuffers, this.insertNodeBuffers, this.tabletBuffers);
    }

    @Override
    protected long getMaxBatchSizeInBytes() {
        return this.allocatedMemoryBlock.getMemoryUsageInBytes();
    }

    public Map<Pair<String, Long>, Long> deepCopyPipeName2BytesAccumulated() {
        return new HashMap<Pair<String, Long>, Long>(this.pipe2BytesAccumulated);
    }

    public Map<Pair<String, Long>, Long> getPipe2BytesAccumulated() {
        return this.pipe2BytesAccumulated;
    }

    private int buildTabletInsertionBuffer(TabletInsertionEvent event) throws IOException, WALPipeException {
        ByteBuffer buffer;
        if (event instanceof PipeInsertNodeTabletInsertionEvent) {
            PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)event;
            InsertNode insertNode = pipeInsertNodeTabletInsertionEvent.getInsertNodeViaCacheIfPossible();
            if (Objects.isNull(insertNode)) {
                buffer = pipeInsertNodeTabletInsertionEvent.getByteBuffer();
                this.binaryBuffers.add(buffer);
            } else {
                buffer = insertNode.serializeToByteBuffer();
                this.insertNodeBuffers.add(buffer);
            }
        } else {
            PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent = (PipeRawTabletInsertionEvent)event;
            try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
                 DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                pipeRawTabletInsertionEvent.convertToTablet().serialize(outputStream);
                ReadWriteIOUtils.write((Boolean)pipeRawTabletInsertionEvent.isAligned(), (OutputStream)outputStream);
                buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            this.tabletBuffers.add(buffer);
        }
        return buffer.limit();
    }

    @Override
    public synchronized void close() {
        super.close();
        this.allocatedMemoryBlock.close();
    }
}

