/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.expression.unary;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.strategy.optimizer.ConcatPathOptimizer;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.expression.unary.TimeSeriesOperand;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.db.query.udf.core.executor.UDTFExecutor;
import org.apache.iotdb.db.query.udf.core.layer.IntermediateLayer;
import org.apache.iotdb.db.query.udf.core.layer.LayerMemoryAssigner;
import org.apache.iotdb.db.query.udf.core.layer.MultiInputColumnIntermediateLayer;
import org.apache.iotdb.db.query.udf.core.layer.RawQueryInputLayer;
import org.apache.iotdb.db.query.udf.core.layer.SingleInputColumnMultiReferenceIntermediateLayer;
import org.apache.iotdb.db.query.udf.core.layer.SingleInputColumnSingleReferenceIntermediateLayer;
import org.apache.iotdb.db.query.udf.core.transformer.Transformer;
import org.apache.iotdb.db.query.udf.core.transformer.TransparentTransformer;
import org.apache.iotdb.db.query.udf.core.transformer.UDFQueryRowTransformer;
import org.apache.iotdb.db.query.udf.core.transformer.UDFQueryRowWindowTransformer;
import org.apache.iotdb.db.query.udf.core.transformer.UDFQueryTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class FunctionExpression
extends Expression {
    private final boolean isPlainAggregationFunctionExpression;
    private boolean isUserDefinedAggregationFunctionExpression;
    private final String functionName;
    private final Map<String, String> functionAttributes;
    private List<Expression> expressions;
    private List<PartialPath> paths;
    private String parametersString;

    public FunctionExpression(String functionName) {
        this.functionName = functionName;
        this.functionAttributes = new LinkedHashMap<String, String>();
        this.expressions = new ArrayList<Expression>();
        this.isPlainAggregationFunctionExpression = SQLConstant.getNativeFunctionNames().contains(functionName.toLowerCase());
        this.isConstantOperandCache = true;
    }

    public FunctionExpression(String functionName, Map<String, String> functionAttributes, List<Expression> expressions) {
        this.functionName = functionName;
        this.functionAttributes = functionAttributes;
        this.expressions = expressions;
        this.isPlainAggregationFunctionExpression = SQLConstant.getNativeFunctionNames().contains(functionName.toLowerCase());
        this.isConstantOperandCache = expressions.stream().anyMatch(Expression::isConstantOperand);
        this.isUserDefinedAggregationFunctionExpression = expressions.stream().anyMatch(v -> v.isUserDefinedAggregationFunctionExpression() || v.isPlainAggregationFunctionExpression());
    }

    @Override
    public boolean isPlainAggregationFunctionExpression() {
        return this.isPlainAggregationFunctionExpression;
    }

    @Override
    public boolean isConstantOperandInternal() {
        return this.isConstantOperandCache;
    }

    @Override
    public boolean isTimeSeriesGeneratingFunctionExpression() {
        return !this.isPlainAggregationFunctionExpression() && !this.isUserDefinedAggregationFunctionExpression();
    }

    @Override
    public boolean isUserDefinedAggregationFunctionExpression() {
        return this.isUserDefinedAggregationFunctionExpression;
    }

    public boolean isCountStar() {
        return this.getPaths().size() == 1 && (this.paths.get(0).getTailNode().equals("*") || this.paths.get(0).getTailNode().equals("**")) && this.functionName.equalsIgnoreCase("count");
    }

    public void addAttribute(String key, String value) {
        this.functionAttributes.put(key, value);
    }

    public void addExpression(Expression expression) {
        this.isConstantOperandCache = this.isConstantOperandCache != false && expression.isConstantOperand();
        this.isUserDefinedAggregationFunctionExpression = this.isUserDefinedAggregationFunctionExpression || expression.isUserDefinedAggregationFunctionExpression() || expression.isPlainAggregationFunctionExpression();
        this.expressions.add(expression);
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Map<String, String> getFunctionAttributes() {
        return this.functionAttributes;
    }

    @Override
    public List<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void concat(List<PartialPath> prefixPaths, List<Expression> resultExpressions) {
        ArrayList resultExpressionsForRecursionList = new ArrayList();
        for (Expression suffixExpression : this.expressions) {
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            suffixExpression.concat(prefixPaths, arrayList);
            resultExpressionsForRecursionList.add(arrayList);
        }
        ArrayList functionExpressions = new ArrayList();
        ConcatPathOptimizer.cartesianProduct(resultExpressionsForRecursionList, functionExpressions, 0, new ArrayList());
        for (List list : functionExpressions) {
            resultExpressions.add(new FunctionExpression(this.functionName, this.functionAttributes, list));
        }
    }

    @Override
    public void removeWildcards(WildcardsRemover wildcardsRemover, List<Expression> resultExpressions) throws LogicalOptimizeException {
        for (List<Expression> functionExpression : wildcardsRemover.removeWildcardsFrom(this.expressions)) {
            resultExpressions.add(new FunctionExpression(this.functionName, this.functionAttributes, functionExpression));
        }
    }

    @Override
    public void collectPaths(Set<PartialPath> pathSet) {
        for (Expression expression : this.expressions) {
            expression.collectPaths(pathSet);
        }
    }

    @Override
    public void constructUdfExecutors(Map<String, UDTFExecutor> expressionName2Executor, ZoneId zoneId) {
        String expressionString = this.getExpressionString();
        if (expressionName2Executor.containsKey(expressionString)) {
            return;
        }
        for (Expression expression : this.expressions) {
            expression.constructUdfExecutors(expressionName2Executor, zoneId);
        }
        expressionName2Executor.put(expressionString, new UDTFExecutor(this, zoneId));
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        for (Expression expression : this.expressions) {
            expression.updateStatisticsForMemoryAssigner(memoryAssigner);
        }
        memoryAssigner.increaseExpressionReference(this);
    }

    @Override
    public IntermediateLayer constructIntermediateLayer(long queryId, UDTFPlan udtfPlan, RawQueryInputLayer rawTimeSeriesInputLayer, Map<Expression, IntermediateLayer> expressionIntermediateLayerMap, Map<Expression, TSDataType> expressionDataTypeMap, LayerMemoryAssigner memoryAssigner) throws QueryProcessException, IOException {
        if (!expressionIntermediateLayerMap.containsKey(this)) {
            Transformer transformer;
            float memoryBudgetInMB = memoryAssigner.assign();
            if (this.isPlainAggregationFunctionExpression) {
                transformer = new TransparentTransformer(rawTimeSeriesInputLayer.constructPointReader(udtfPlan.getReaderIndexByExpressionName(this.toString())));
            } else {
                IntermediateLayer udfInputIntermediateLayer = this.constructUdfInputIntermediateLayer(queryId, udtfPlan, rawTimeSeriesInputLayer, expressionIntermediateLayerMap, expressionDataTypeMap, memoryAssigner);
                transformer = this.constructUdfTransformer(queryId, udtfPlan, expressionDataTypeMap, memoryAssigner, udfInputIntermediateLayer);
            }
            expressionDataTypeMap.put(this, transformer.getDataType());
            expressionIntermediateLayerMap.put(this, memoryAssigner.getReference(this) == 1 ? new SingleInputColumnSingleReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, transformer) : new SingleInputColumnMultiReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, transformer));
        }
        return expressionIntermediateLayerMap.get(this);
    }

    private IntermediateLayer constructUdfInputIntermediateLayer(long queryId, UDTFPlan udtfPlan, RawQueryInputLayer rawTimeSeriesInputLayer, Map<Expression, IntermediateLayer> expressionIntermediateLayerMap, Map<Expression, TSDataType> expressionDataTypeMap, LayerMemoryAssigner memoryAssigner) throws QueryProcessException, IOException {
        ArrayList<IntermediateLayer> intermediateLayers = new ArrayList<IntermediateLayer>();
        for (Expression expression : this.expressions) {
            intermediateLayers.add(expression.constructIntermediateLayer(queryId, udtfPlan, rawTimeSeriesInputLayer, expressionIntermediateLayerMap, expressionDataTypeMap, memoryAssigner));
        }
        return intermediateLayers.size() == 1 ? (IntermediateLayer)intermediateLayers.get(0) : new MultiInputColumnIntermediateLayer(this, queryId, memoryAssigner.assign(), intermediateLayers.stream().map(IntermediateLayer::constructPointReader).collect(Collectors.toList()));
    }

    private UDFQueryTransformer constructUdfTransformer(long queryId, UDTFPlan udtfPlan, Map<Expression, TSDataType> expressionDataTypeMap, LayerMemoryAssigner memoryAssigner, IntermediateLayer udfInputIntermediateLayer) throws QueryProcessException, IOException {
        UDTFExecutor executor = udtfPlan.getExecutorByFunctionExpression(this);
        executor.beforeStart(queryId, memoryAssigner.assign(), expressionDataTypeMap);
        AccessStrategy accessStrategy = executor.getConfigurations().getAccessStrategy();
        switch (accessStrategy.getAccessStrategyType()) {
            case ROW_BY_ROW: {
                return new UDFQueryRowTransformer(udfInputIntermediateLayer.constructRowReader(), executor);
            }
            case SLIDING_SIZE_WINDOW: 
            case SLIDING_TIME_WINDOW: {
                return new UDFQueryRowWindowTransformer(udfInputIntermediateLayer.constructRowWindowReader(accessStrategy, memoryAssigner.assign()), executor);
            }
        }
        throw new UnsupportedOperationException("Unsupported transformer access strategy");
    }

    public List<PartialPath> getPaths() {
        if (this.paths == null) {
            this.paths = new ArrayList<PartialPath>();
            for (Expression expression : this.expressions) {
                this.paths.add(expression instanceof TimeSeriesOperand ? ((TimeSeriesOperand)expression).getPath() : null);
            }
        }
        return this.paths;
    }

    @Override
    public String getExpressionStringInternal() {
        return this.functionName + "(" + this.getParametersString() + ")";
    }

    private String getParametersString() {
        if (this.parametersString == null) {
            StringBuilder builder = new StringBuilder();
            if (!this.expressions.isEmpty()) {
                builder.append(this.expressions.get(0).toString());
                for (int i = 1; i < this.expressions.size(); ++i) {
                    builder.append(", ").append(this.expressions.get(i).toString());
                }
            }
            if (!this.functionAttributes.isEmpty()) {
                if (!this.expressions.isEmpty()) {
                    builder.append(", ");
                }
                Iterator<Map.Entry<String, String>> iterator = this.functionAttributes.entrySet().iterator();
                Map.Entry<String, String> entry = iterator.next();
                builder.append("\"").append(entry.getKey()).append("\"=\"").append(entry.getValue()).append("\"");
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    builder.append(", ").append("\"").append(entry.getKey()).append("\"=\"").append(entry.getValue()).append("\"");
                }
            }
            this.parametersString = builder.toString();
        }
        return this.parametersString;
    }
}

