/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor.fill;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class LastPointReader {
    private final PartialPath seriesPath;
    long queryTime;
    TSDataType dataType;
    private final QueryContext context;
    private final Set<String> measurements;
    private final Filter timeFilter;
    private final QueryDataSource dataSource;
    private IChunkMetadata cachedLastChunk;
    private final List<ITimeSeriesMetadata> unseqTimeseriesMetadataList = new ArrayList<ITimeSeriesMetadata>();

    public LastPointReader(PartialPath seriesPath, TSDataType dataType, Set<String> measurements, QueryContext context, QueryDataSource dataSource, long queryTime, Filter timeFilter) {
        this.seriesPath = IDTable.translateQueryPath(seriesPath);
        this.dataType = dataType;
        this.dataSource = dataSource;
        this.context = context;
        this.queryTime = queryTime;
        this.measurements = measurements;
        this.timeFilter = timeFilter;
    }

    public TimeValuePair readLastPoint() throws IOException {
        TimeValuePair resultPoint = this.retrieveValidLastPointFromSeqFiles();
        this.UnpackOverlappedUnseqFiles(resultPoint.getTimestamp());
        PriorityQueue<IChunkMetadata> sortedChunkMetatdataList = this.sortUnseqChunkMetadatasByEndtime();
        while (!sortedChunkMetatdataList.isEmpty() && resultPoint.getTimestamp() <= sortedChunkMetatdataList.peek().getEndTime()) {
            IChunkMetadata chunkMetadata = sortedChunkMetatdataList.poll();
            TimeValuePair chunkLastPoint = this.getChunkLastPoint(chunkMetadata);
            if (chunkLastPoint.getTimestamp() <= resultPoint.getTimestamp() && (chunkLastPoint.getTimestamp() != resultPoint.getTimestamp() || this.cachedLastChunk != null && !this.shouldUpdate(this.cachedLastChunk, chunkMetadata))) continue;
            this.cachedLastChunk = chunkMetadata;
            resultPoint = chunkLastPoint;
        }
        return resultPoint;
    }

    private TimeValuePair retrieveValidLastPointFromSeqFiles() throws IOException {
        List<TsFileResource> seqFileResource = this.dataSource.getSeqResources();
        TimeValuePair lastPoint = new TimeValuePair(Long.MIN_VALUE, null);
        for (int index = seqFileResource.size() - 1; index >= 0; --index) {
            TsFileResource resource = seqFileResource.get(index);
            ITimeSeriesMetadata timeseriesMetadata = this.loadTimeSeriesMetadata(resource, this.seriesPath, this.context, this.timeFilter, this.measurements);
            if (timeseriesMetadata == null) continue;
            if (!timeseriesMetadata.isModified() && this.endtimeContainedByTimeFilter(timeseriesMetadata.getStatistics())) {
                return this.constructLastPair(timeseriesMetadata.getStatistics().getEndTime(), timeseriesMetadata.getStatistics().getLastValue(), this.dataType);
            }
            List seqChunkMetadataList = timeseriesMetadata.loadChunkMetadataList();
            for (int i = seqChunkMetadataList.size() - 1; i >= 0; --i) {
                lastPoint = this.getChunkLastPoint((IChunkMetadata)seqChunkMetadataList.get(i));
                if (lastPoint.getValue() == null) continue;
                return lastPoint;
            }
        }
        return lastPoint;
    }

    protected ITimeSeriesMetadata loadTimeSeriesMetadata(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter filter, Set<String> allSensors) throws IOException {
        return FileLoaderUtils.loadTimeSeriesMetadata(resource, seriesPath, context, filter, allSensors);
    }

    private void UnpackOverlappedUnseqFiles(long lBoundTime) throws IOException {
        PriorityQueue<TsFileResource> unseqFileResource = this.sortUnSeqFileResourcesInDecendingOrder(this.dataSource.getUnseqResources());
        while (!unseqFileResource.isEmpty() && lBoundTime <= unseqFileResource.peek().getEndTime(this.seriesPath.getDevice())) {
            ITimeSeriesMetadata timeseriesMetadata = this.loadTimeSeriesMetadata(unseqFileResource.poll(), this.seriesPath, this.context, this.timeFilter, this.measurements);
            if (timeseriesMetadata == null || !timeseriesMetadata.isModified() && timeseriesMetadata.getStatistics().getEndTime() < lBoundTime) continue;
            this.unseqTimeseriesMetadataList.add(timeseriesMetadata);
            if (timeseriesMetadata.isModified()) continue;
            if (this.endtimeContainedByTimeFilter(timeseriesMetadata.getStatistics())) {
                lBoundTime = Math.max(lBoundTime, timeseriesMetadata.getStatistics().getEndTime());
                continue;
            }
            lBoundTime = Math.max(lBoundTime, timeseriesMetadata.getStatistics().getStartTime());
        }
    }

    private TimeValuePair getChunkLastPoint(IChunkMetadata chunkMetaData) throws IOException {
        TimeValuePair lastPoint = new TimeValuePair(Long.MIN_VALUE, null);
        if (chunkMetaData == null || chunkMetaData.getStatistics() == null) {
            return lastPoint;
        }
        Statistics chunkStatistics = chunkMetaData.getStatistics();
        if (!chunkMetaData.isModified() && this.endtimeContainedByTimeFilter(chunkStatistics)) {
            return this.constructLastPair(chunkStatistics.getEndTime(), chunkStatistics.getLastValue(), this.dataType);
        }
        List<IPageReader> pageReaders = FileLoaderUtils.loadPageReaderList(chunkMetaData, this.timeFilter);
        Iterator<Object> it = pageReaders instanceof LinkedList ? ((LinkedList)pageReaders).descendingIterator() : pageReaders.iterator();
        while (it.hasNext()) {
            IPageReader pageReader = (IPageReader)it.next();
            Statistics pageStatistics = pageReader.getStatistics();
            if (pageStatistics != null && !pageReader.isModified() && this.endtimeContainedByTimeFilter(pageStatistics)) {
                lastPoint = this.constructLastPair(pageStatistics.getEndTime(), pageStatistics.getLastValue(), this.dataType);
            } else {
                BatchData batchData = pageReader.getAllSatisfiedPageData();
                lastPoint = batchData.getLastPairBeforeOrEqualTimestamp(this.queryTime);
            }
            if (lastPoint.getValue() == null) continue;
            return lastPoint;
        }
        return lastPoint;
    }

    private boolean shouldUpdate(IChunkMetadata cachedChunk, IChunkMetadata newChunk) {
        return newChunk.getVersion() > cachedChunk.getVersion() || newChunk.getVersion() == cachedChunk.getVersion() && newChunk.getOffsetOfChunkHeader() > cachedChunk.getOffsetOfChunkHeader();
    }

    private PriorityQueue<TsFileResource> sortUnSeqFileResourcesInDecendingOrder(List<TsFileResource> tsFileResources) {
        PriorityQueue<TsFileResource> unseqTsFilesSet = new PriorityQueue<TsFileResource>((o1, o2) -> {
            long maxTimeOfO1 = o1.getEndTime(this.seriesPath.getDevice());
            long maxTimeOfO2 = o2.getEndTime(this.seriesPath.getDevice());
            return Long.compare(maxTimeOfO2, maxTimeOfO1);
        });
        unseqTsFilesSet.addAll(tsFileResources);
        return unseqTsFilesSet;
    }

    private PriorityQueue<IChunkMetadata> sortUnseqChunkMetadatasByEndtime() throws IOException {
        PriorityQueue<IChunkMetadata> chunkMetadataList = new PriorityQueue<IChunkMetadata>((o1, o2) -> {
            long endTime2;
            long endTime1 = o1.getEndTime();
            if (endTime1 < (endTime2 = o2.getEndTime())) {
                return 1;
            }
            if (endTime1 > endTime2) {
                return -1;
            }
            if (o2.getVersion() > o1.getVersion()) {
                return 1;
            }
            return o2.getVersion() < o1.getVersion() ? -1 : Long.compare(o2.getOffsetOfChunkHeader(), o1.getOffsetOfChunkHeader());
        });
        for (ITimeSeriesMetadata timeseriesMetadata : this.unseqTimeseriesMetadataList) {
            if (timeseriesMetadata == null) continue;
            chunkMetadataList.addAll(timeseriesMetadata.loadChunkMetadataList());
        }
        return chunkMetadataList;
    }

    private boolean endtimeContainedByTimeFilter(Statistics statistics) {
        if (this.timeFilter == null) {
            return true;
        }
        return this.timeFilter.containStartEndTime(statistics.getEndTime(), statistics.getEndTime());
    }

    private TimeValuePair constructLastPair(long timestamp, Object value, TSDataType dataType) {
        return new TimeValuePair(timestamp, TsPrimitiveType.getByType((TSDataType)dataType, (Object)value));
    }
}

