/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.archiving;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.iotdb.db.engine.archiving.ArchivingTask;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ArchivingOperate {
    private ArchivingOperateType type;
    private ArchivingTask task;

    public ArchivingOperate(ArchivingOperateType type, ArchivingTask task) {
        this.type = type;
        this.task = new ArchivingTask(task);
    }

    public ArchivingOperate(ArchivingOperateType type, long taskId) {
        this.type = type;
        this.task = new ArchivingTask(taskId);
    }

    public ArchivingOperateType getType() {
        return this.type;
    }

    public ArchivingTask getTask() {
        return this.task;
    }

    public void serialize(FileOutputStream logFileOutStream) throws IOException {
        int typeNum = this.type.ordinal();
        ReadWriteIOUtils.write((byte)((byte)typeNum), (OutputStream)logFileOutStream);
        ReadWriteIOUtils.write((long)this.task.getTaskId(), (OutputStream)logFileOutStream);
        if (this.type == ArchivingOperateType.SET) {
            ReadWriteIOUtils.write((String)this.task.getStorageGroup().getFullPath(), (OutputStream)logFileOutStream);
            ReadWriteIOUtils.write((String)this.task.getTargetDir().getPath(), (OutputStream)logFileOutStream);
            ReadWriteIOUtils.write((long)this.task.getStartTime(), (OutputStream)logFileOutStream);
            ReadWriteIOUtils.write((long)this.task.getTTL(), (OutputStream)logFileOutStream);
            ReadWriteIOUtils.write((long)this.task.getSubmitTime(), (OutputStream)logFileOutStream);
        }
        logFileOutStream.flush();
    }

    public static ArchivingOperate deserialize(FileInputStream logFileInStream) throws IOException, IllegalPathException {
        ArchivingTask deserializedTask;
        byte typeNum = ReadWriteIOUtils.readByte((InputStream)logFileInStream);
        if (typeNum < 0 || typeNum >= ArchivingOperateType.values().length) {
            throw new IOException();
        }
        ArchivingOperateType operateType = ArchivingOperateType.values()[typeNum];
        long taskId = ReadWriteIOUtils.readLong((InputStream)logFileInStream);
        if (operateType == ArchivingOperateType.SET) {
            PartialPath storageGroup = new PartialPath(ReadWriteIOUtils.readString((InputStream)logFileInStream));
            String targetDirPath = ReadWriteIOUtils.readString((InputStream)logFileInStream);
            File targetDir = FSFactoryProducer.getFSFactory().getFile(targetDirPath);
            long startTime = ReadWriteIOUtils.readLong((InputStream)logFileInStream);
            long ttl = ReadWriteIOUtils.readLong((InputStream)logFileInStream);
            long submitTime = ReadWriteIOUtils.readLong((InputStream)logFileInStream);
            deserializedTask = new ArchivingTask(taskId, storageGroup, targetDir, ttl, startTime, submitTime);
        } else {
            deserializedTask = new ArchivingTask(taskId);
        }
        return new ArchivingOperate(operateType, deserializedTask);
    }

    public static enum ArchivingOperateType {
        SET,
        CANCEL,
        START,
        PAUSE,
        RESUME,
        FINISHED,
        ERROR;

    }
}

