/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.monitor;

import java.util.concurrent.atomic.AtomicInteger;

public class Peer {
    private long nextIndex;
    private long matchIndex;
    private AtomicInteger inconsistentHeartbeatNum = new AtomicInteger();
    private long lastHeartBeatIndex;

    public Peer(long nextIndex) {
        this.nextIndex = nextIndex;
        this.matchIndex = -1L;
    }

    public synchronized long getNextIndex() {
        return this.nextIndex;
    }

    public synchronized void setNextIndex(long nextIndex) {
        this.nextIndex = nextIndex;
    }

    public synchronized long getMatchIndex() {
        return this.matchIndex;
    }

    public synchronized void setMatchIndex(long matchIndex) {
        this.matchIndex = matchIndex;
        this.setNextIndex(Math.max(this.nextIndex, matchIndex + 1L));
        this.notifyAll();
    }

    public int incInconsistentHeartbeatNum() {
        return this.inconsistentHeartbeatNum.incrementAndGet();
    }

    public void resetInconsistentHeartbeatNum() {
        this.inconsistentHeartbeatNum.set(0);
    }

    public long getLastHeartBeatIndex() {
        return this.lastHeartBeatIndex;
    }

    public void setLastHeartBeatIndex(long lastHeartBeatIndex) {
        this.lastHeartBeatIndex = lastHeartBeatIndex;
    }
}

