import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useEffect } from "react";
import * as ReactDOM from "react-dom";
import { createAndGetMainContainer, extractOpenFileExtension, extractOpenFilePath, iframeFullscreenContainer, removeAllChildren, runScriptOnPage, waitForElementToBeReady, } from "../../utils";
import { SingleEditorApp } from "./SingleEditorApp";
import { Main } from "../common/Main";
import { KOGITO_IFRAME_CONTAINER_CLASS, KOGITO_TOOLBAR_CONTAINER_CLASS } from "../../constants";
import { useGlobals } from "../common/GlobalContext";
export async function renderSingleEditorApp(args) {
    await waitForElementToBeReady(".cm-content");
    if (!args.dependencies.singleEdit.githubTextEditorToReplaceElement()) {
        args.logger.log(`Doesn't look like the GitHub page is ready yet.`);
        return;
    }
    const openFileExtension = extractOpenFileExtension(window.location.href);
    const openFilePath = extractOpenFilePath(window.location.href);
    if (!openFileExtension) {
        args.logger.log(`Unable to determine file extension from URL.`);
        return;
    }
    if (!args.editorEnvelopeLocator.hasMappingFor(openFilePath)) {
        args.logger.log(`No enhanced editor available for "${openFilePath}" format.`);
        return;
    }
    cleanup(args.id, args.dependencies);
    ReactDOM.render(_jsx(Main, { id: args.id, editorEnvelopeLocator: args.editorEnvelopeLocator, dependencies: args.dependencies, logger: args.logger, githubAuthTokenCookieName: args.githubAuthTokenCookieName, extensionIconUrl: args.extensionIconUrl, resourceContentServiceFactory: args.resourceContentServiceFactory, externalEditorManager: args.externalEditorManager, customChannelApiImpl: args.customChannelApiImpl, stateControl: args.stateControl, children: _jsx(SingleEditorEditApp, { openFileExtension: openFileExtension, fileInfo: args.fileInfo }) }), createAndGetMainContainer(args.id, args.dependencies.all.body()), () => args.logger.log("Mounted."));
}
function SingleEditorEditApp(props) {
    const globals = useGlobals();
    useEffect(() => {
        runScriptOnPage(chrome.runtime.getURL("scripts/set_content.js"));
    }, [props.fileInfo]);
    const getFileName = useCallback(() => {
        return globals.dependencies.all.edit__githubFileNameInput().value;
    }, [globals.dependencies]);
    const getFileContents = useCallback(() => {
        var _a, _b;
        return Promise.resolve((_b = (_a = globals.dependencies.all.edit__githubTextAreaWithFileContents()) === null || _a === void 0 ? void 0 : _a.textContent) !== null && _b !== void 0 ? _b : "");
    }, [globals.dependencies]);
    return (_jsx(SingleEditorApp, { readonly: false, openFileExtension: props.openFileExtension, getFileName: getFileName, getFileContents: getFileContents, iframeContainer: iframeContainer(globals.id, globals.dependencies), toolbarContainer: toolbarContainer(globals.id, globals.dependencies), githubTextEditorToReplace: globals.dependencies.singleEdit.githubTextEditorToReplaceElement(), fileInfo: props.fileInfo }));
}
function cleanup(id, dependencies) {
    removeAllChildren(iframeContainer(id, dependencies));
    removeAllChildren(toolbarContainer(id, dependencies));
    removeAllChildren(iframeFullscreenContainer(id, dependencies.all.body()));
    removeAllChildren(createAndGetMainContainer(id, dependencies.all.body()));
}
function toolbarContainer(id, dependencies) {
    var _a;
    const element = () => document.querySelector(`.${KOGITO_TOOLBAR_CONTAINER_CLASS}.${id}`);
    if (element) {
        (_a = element()) === null || _a === void 0 ? void 0 : _a.remove();
    }
    dependencies.singleEdit
        .toolbarContainerTarget()
        .insertAdjacentHTML("beforebegin", `<div style="width:100%; padding-bottom: 10px;" class="${KOGITO_TOOLBAR_CONTAINER_CLASS} ${id} edit d-flex flex-column flex-items-start flex-md-row"></div>`);
    return element();
}
function iframeContainer(id, dependencies) {
    var _a;
    const element = () => document.querySelector(`.${KOGITO_IFRAME_CONTAINER_CLASS}.${id}`);
    if (element) {
        (_a = element()) === null || _a === void 0 ? void 0 : _a.remove();
    }
    dependencies.singleEdit
        .iframeContainerTarget()
        .insertAdjacentHTML("afterend", `<div class="${KOGITO_IFRAME_CONTAINER_CLASS} ${id} edit"></div>`);
    return element();
}
//# sourceMappingURL=singleEditorEdit.js.map