import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { GlobalContext, useGlobals } from "./GlobalContext";
import { GitHubContextProvider, useGitHubApi } from "./GitHubContext";
import * as ReactDOM from "react-dom";
import { KogitoMenu } from "./KogitoMenu";
import { kogitoMenuContainer } from "../../utils";
import { I18nDictionariesProvider } from "@kie-tools-core/i18n/dist/react-components";
import { chromeExtensionI18nDictionaries, chromeExtensionI18nDefaults, ChromeExtensionI18nContext } from "../../i18n";
function KogitoMenuPortal(props) {
    const githubApi = useGitHubApi();
    const globals = useGlobals();
    if (githubApi.userIsLoggedIn()) {
        return (_jsx(_Fragment, { children: ReactDOM.createPortal(_jsx(KogitoMenu, {}), kogitoMenuContainer(props.id, globals.dependencies.all.notificationIndicator().parentElement)) }));
    }
    else {
        return (_jsx(_Fragment, { children: ReactDOM.createPortal(_jsx(KogitoMenu, {}), kogitoMenuContainer(props.id, globals.dependencies.all.notLoggedInNotificationIndicator())) }));
    }
}
export const Main = (props) => {
    return (_jsx(I18nDictionariesProvider, { defaults: chromeExtensionI18nDefaults, dictionaries: chromeExtensionI18nDictionaries, initialLocale: navigator.language, ctx: ChromeExtensionI18nContext, children: _jsx(GlobalContext.Provider, { value: {
                id: props.id,
                logger: props.logger,
                dependencies: props.dependencies,
                envelopeLocator: props.editorEnvelopeLocator,
                githubAuthTokenCookieName: props.githubAuthTokenCookieName,
                extensionIconUrl: props.extensionIconUrl,
                resourceContentServiceFactory: props.resourceContentServiceFactory,
                externalEditorManager: props.externalEditorManager,
                customChannelApiImpl: props.customChannelApiImpl,
                stateControl: props.stateControl,
            }, children: _jsxs(GitHubContextProvider, { children: [_jsx(KogitoMenuPortal, { id: props.id }), props.children] }) }) }));
};
//# sourceMappingURL=Main.js.map