import { ResourceContent, ResourcesList, } from "@kie-tools-core/workspace/dist/api";
import { fetchFile } from "../../github/api";
import * as minimatch from "minimatch";
class ChromeResourceContentService {
    constructor(octokit, repoInfo) {
        this.octokit = octokit;
        this.repoInfo = repoInfo;
    }
    get(normalizedPosixPathRelativeToTheWorkspaceRoot, opts) {
        opts = opts !== null && opts !== void 0 ? opts : { type: "text" };
        return fetchFile(this.octokit, this.repoInfo.owner, this.repoInfo.repo, this.repoInfo.gitref, normalizedPosixPathRelativeToTheWorkspaceRoot, opts.type)
            .then((resourceContent) => new ResourceContent(normalizedPosixPathRelativeToTheWorkspaceRoot, resourceContent, opts.type))
            .catch((e) => {
            console.debug(e);
            console.debug(`Error retrieving content from URI ${normalizedPosixPathRelativeToTheWorkspaceRoot}`);
            return undefined;
        });
    }
    list(pattern, opts) {
        return this.octokit.git
            .getTree({
            recursive: "1",
            tree_sha: this.repoInfo.gitref,
            ...this.repoInfo,
        })
            .then((v) => {
            const filteredPaths = v.data.tree.filter((file) => file.type === "blob").map((file) => file.path);
            const result = minimatch.match(filteredPaths, pattern);
            return new ResourcesList(pattern, result);
        })
            .catch((e) => {
            console.debug(`Error retrieving file list for pattern ${pattern}`);
            return new ResourcesList(pattern, []);
        });
    }
}
export class ResourceContentServiceFactory {
    createNew(octokit, repoInfo) {
        return new ChromeResourceContentService(octokit, repoInfo);
    }
}
//# sourceMappingURL=ChromeResourceContentService.js.map