export class WorkflowListGatewayApiImpl {
    constructor(queries) {
        this.onOpenWorkflowListeners = [];
        this.onOpenTriggerCloudEventListeners = [];
        this.openWorkflow = (workflow) => {
            this.onOpenWorkflowListeners.forEach((listener) => listener.onOpen(workflow));
            return Promise.resolve();
        };
        this.initialLoad = (filter, sortBy) => {
            this._WorkflowListState.filters = filter;
            this._WorkflowListState.sortBy = sortBy;
            return Promise.resolve();
        };
        this.applyFilter = (filter) => {
            this.workflowListState.filters = filter;
            return Promise.resolve();
        };
        this.applySorting = (sortBy) => {
            this._WorkflowListState.sortBy = sortBy;
            return Promise.resolve();
        };
        this.handleWorkflowSkip = async (workflowInstance) => {
            return this.queries.handleWorkflowSkip(workflowInstance);
        };
        this.handleWorkflowRetry = async (workflowInstance) => {
            return this.queries.handleWorkflowRetry(workflowInstance);
        };
        this.handleWorkflowAbort = async (workflowInstance) => {
            return this.queries.handleWorkflowAbort(workflowInstance);
        };
        this.handleWorkflowMultipleAction = async (workflowInstances, operationType) => {
            return this.queries.handleWorkflowMultipleAction(workflowInstances, operationType);
        };
        this.queries = queries;
        this._WorkflowListState = {
            filters: {
                status: [],
                businessKey: [],
            },
            sortBy: {},
        };
    }
    get workflowListState() {
        return this._WorkflowListState;
    }
    query(offset, limit) {
        return new Promise((resolve, reject) => {
            this.queries
                .getWorkflowInstances(offset, limit, this._WorkflowListState.filters, this._WorkflowListState.sortBy)
                .then((value) => {
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
    getChildWorkflowsQuery(rootWorkflowInstanceId) {
        return new Promise((resolve, reject) => {
            this.queries
                .getChildWorkflowInstances(rootWorkflowInstanceId)
                .then((value) => {
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
    onOpenWorkflowListen(listener) {
        this.onOpenWorkflowListeners.push(listener);
        const unSubscribe = () => {
            const index = this.onOpenWorkflowListeners.indexOf(listener);
            if (index > -1) {
                this.onOpenWorkflowListeners.splice(index, 1);
            }
        };
        return {
            unSubscribe,
        };
    }
    onOpenTriggerCloudEventListen(listener) {
        this.onOpenTriggerCloudEventListeners.push(listener);
        const unSubscribe = () => {
            const index = this.onOpenTriggerCloudEventListeners.indexOf(listener);
            if (index > -1) {
                this.onOpenTriggerCloudEventListeners.splice(index, 1);
            }
        };
        return {
            unSubscribe,
        };
    }
    openTriggerCloudEvent(workflowInstance) {
        this.onOpenTriggerCloudEventListeners.forEach((listener) => listener.onOpen(workflowInstance));
    }
}
//# sourceMappingURL=WorkflowListGatewayApi.js.map