import { getCustomWorkflowSchema, startWorkflowRest } from "@kie-tools/runtime-tools-swf-gateway-api/dist/gatewayApi";
export class WorkflowFormGatewayApiImpl {
    constructor(openApiPath, proxyEndpoint) {
        this.businessKey = "";
        this.openApiPath = openApiPath;
        this.proxyEndpoint = proxyEndpoint;
    }
    setBusinessKey(bk) {
        this.businessKey = bk;
    }
    getBusinessKey() {
        return this.businessKey;
    }
    getCustomWorkflowSchema(workflowName, serviceUrl) {
        return getCustomWorkflowSchema(serviceUrl, this.openApiPath, workflowName, this.proxyEndpoint);
    }
    async startWorkflow(endpoint, data) {
        return (await startWorkflowRest(data, endpoint, this.businessKey, this.proxyEndpoint)).id;
    }
}
//# sourceMappingURL=WorkflowFormGatewayApi.js.map