import { WorkflowDefinition } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { WorkflowDefinitionListQueries } from "../WorkflowDefinitionList/WorkflowDefinitionListQueries";
export interface WorkflowDefinitionListGatewayApi {
    getWorkflowDefinitionFilter: () => Promise<string[]>;
    setWorkflowDefinitionFilter: (filter: string[]) => Promise<void>;
    getWorkflowDefinitionsQuery: () => Promise<WorkflowDefinition[]>;
    openWorkflowForm: (workflowDefinition: WorkflowDefinition) => Promise<void>;
    openTriggerCloudEvent: (workflowDefinition: WorkflowDefinition) => Promise<void>;
    onOpenWorkflowFormListen: (listener: OnOpenWorkflowFormListener) => UnSubscribeHandler;
    onOpenTriggerCloudEventListen: (listener: OnOpenTriggerCloudEventListener) => UnSubscribeHandler;
}
export interface OnOpenWorkflowFormListener {
    onOpen: (workflowDefinition: WorkflowDefinition) => void;
}
export interface OnOpenTriggerCloudEventListener {
    onOpen: (workflowDefinition: WorkflowDefinition) => void;
}
export interface UnSubscribeHandler {
    unSubscribe: () => void;
}
export declare class WorkflowDefinitionListGatewayApiImpl implements WorkflowDefinitionListGatewayApi {
    private readonly onOpenWorkflowListeners;
    private readonly onOpenTriggerCloudEventListeners;
    private readonly queries;
    private workflowDefinitionFilter;
    constructor(queries: WorkflowDefinitionListQueries);
    getWorkflowDefinitionFilter(): Promise<string[]>;
    setWorkflowDefinitionFilter(filter: string[]): Promise<void>;
    openWorkflowForm(workflowDefinition: WorkflowDefinition): Promise<void>;
    onOpenWorkflowFormListen(listener: OnOpenWorkflowFormListener): UnSubscribeHandler;
    onOpenTriggerCloudEventListen(listener: OnOpenTriggerCloudEventListener): UnSubscribeHandler;
    getWorkflowDefinitionsQuery(): Promise<WorkflowDefinition[]>;
    openTriggerCloudEvent(workflowDefinition: WorkflowDefinition): Promise<void>;
}
//# sourceMappingURL=WorkflowDefinitionListGatewayApi.d.ts.map