import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import React, { useEffect, useState } from "react";
import { FormNotification } from "@kie-tools/runtime-tools-components/dist/components/FormNotification";
import { componentOuiaProps, ouiaPageTypeAndObjectId, } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { Card, CardBody } from "@patternfly/react-core/dist/js/components/Card";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Text, TextContent, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { CloudEventFormContainer } from "../CloudEventFormContainer/CloudEventFormContainer";
export var CloudEventPageSource;
(function (CloudEventPageSource) {
    CloudEventPageSource["DEFINITIONS"] = "definitions";
    CloudEventPageSource["INSTANCES"] = "instances";
})(CloudEventPageSource || (CloudEventPageSource = {}));
export const CloudEventForm = ({ instanceId, isTriggerNewInstance, cloudEventSource, onStartWorkflowError, onTriggerCloudEventSuccess, onTriggerStartCloudEventSuccess, serviceUrl, ouiaId, ouiaSafe, }) => {
    const [notification, setNotification] = useState();
    useEffect(() => {
        return ouiaPageTypeAndObjectId("trigger-cloud-event-form");
    }, []);
    return (_jsxs(React.Fragment, { children: [_jsxs(PageSection, { ...componentOuiaProps(`title${ouiaId ? "-" + ouiaId : ""}`, "trigger-cloud-event-form-page-section", ouiaSafe), variant: "light", children: [_jsx(TextContent, { children: _jsx(Text, { component: TextVariants.h1, children: "Trigger Cloud Event" }) }), notification && (_jsx("div", { children: _jsx(FormNotification, { notification: notification }) }))] }), _jsx(PageSection, { ...componentOuiaProps(`content${ouiaId ? "-" + ouiaId : ""}`, "cloud-event-form-page-section", ouiaSafe), children: _jsx(Card, { className: "Dev-ui__card-size", children: _jsx(CardBody, { className: "pf-u-h-100", children: _jsx(CloudEventFormContainer, { instanceId: instanceId, isTriggerNewInstance: isTriggerNewInstance, cloudEventSource: cloudEventSource, onStartWorkflowError: onStartWorkflowError, onTriggerCloudEventSuccess: onTriggerCloudEventSuccess, onTriggerStartCloudEventSuccess: onTriggerStartCloudEventSuccess, serviceUrl: serviceUrl }) }) }) })] }));
};
//# sourceMappingURL=CloudEventForm.js.map