import { KieSandboxWorkspacesFs } from "./KieSandboxWorkspaceFs";
import { BroadcasterDispatch, FsService } from "./FsService";
import { FsSchema } from "./FsCache";
import { FsFlushManager } from "./FsFlushManager";
export declare class WorkspaceFsService {
    private readonly fsFlushManager;
    private readonly fsService;
    constructor(fsFlushManager: FsFlushManager, fsService?: FsService);
    withReadWriteInMemoryFs<T>(workspaceId: string, callback: (args: {
        fs: KieSandboxWorkspacesFs;
        schema: FsSchema;
        broadcaster: BroadcasterDispatch;
    }) => Promise<T>): Promise<T>;
    withReadonlyInMemoryFs<T>(workspaceId: string, callback: (args: {
        fs: KieSandboxWorkspacesFs;
        schema: FsSchema;
    }) => Promise<T>): Promise<T>;
    withReadonlyFsSchema<T>(workspaceId: string, callback: (args: {
        schema: FsSchema;
    }) => Promise<T>): Promise<T>;
    getFsMountPoint(workspaceId: string): string;
    getFsSchemaMountPoint(workspaceId: string): string;
}
//# sourceMappingURL=WorkspaceFsService.d.ts.map