"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitService = exports.FileModificationStatus = void 0;
var isomorphic_git_1 = __importStar(require("isomorphic-git"));
var web_1 = __importDefault(require("isomorphic-git/http/web"));
var GitConstants_1 = require("../constants/GitConstants");
var dist_1 = require("@kie-tools/cors-proxy-api/dist");
var FileModificationStatus;
(function (FileModificationStatus) {
    FileModificationStatus["added"] = "added";
    FileModificationStatus["modified"] = "modified";
    FileModificationStatus["deleted"] = "deleted";
})(FileModificationStatus || (exports.FileModificationStatus = FileModificationStatus = {}));
var GitService = (function () {
    function GitService(corsProxy) {
        this.corsProxy = corsProxy;
    }
    GitService.prototype.getRequestHeaders = function (args) {
        var _a;
        return args.insecurelyDisableTlsCertificateValidation
            ? (_a = {},
                _a[dist_1.CorsProxyHeaderKeys.INSECURELY_DISABLE_TLS_CERTIFICATE_VALIDATION] = Boolean(args.insecurelyDisableTlsCertificateValidation).toString(),
                _a) : undefined;
    };
    GitService.prototype.listServerRefs = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b;
            var _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _b = (_a = isomorphic_git_1.default).listServerRefs;
                        _c = {
                            http: web_1.default
                        };
                        return [4, this.corsProxy];
                    case 1: return [2, _b.apply(_a, [(_c.corsProxy = _d.sent(),
                                _c.headers = this.getRequestHeaders(args),
                                _c.onAuth = function () { return args.authInfo; },
                                _c.url = args.url,
                                _c.symrefs = true,
                                _c.protocolVersion = 1,
                                _c)])];
                }
            });
        });
    };
    GitService.prototype.clone = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b;
            var _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        console.time("GitService#clone");
                        _b = (_a = isomorphic_git_1.default).clone;
                        _c = {
                            fs: args.fs,
                            http: web_1.default
                        };
                        return [4, this.corsProxy];
                    case 1: return [4, _b.apply(_a, [(_c.corsProxy = _d.sent(),
                                _c.headers = this.getRequestHeaders(args),
                                _c.dir = args.dir,
                                _c.url = args.repositoryUrl.href,
                                _c.singleBranch = true,
                                _c.noTags = true,
                                _c.depth = 1,
                                _c.ref = args.sourceBranch,
                                _c.onAuth = function () { return args.authInfo; },
                                _c)])];
                    case 2:
                        _d.sent();
                        if (!args.gitConfig) return [3, 4];
                        return [4, this.setupGitConfig(args.fs, args.dir, args.gitConfig)];
                    case 3:
                        _d.sent();
                        _d.label = 4;
                    case 4:
                        console.timeEnd("GitService#clone");
                        return [2];
                }
            });
        });
    };
    GitService.prototype.branch = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, isomorphic_git_1.default.branch({
                            fs: args.fs,
                            dir: args.dir,
                            ref: args.name,
                            checkout: args.checkout,
                        })];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    GitService.prototype.addRemote = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, isomorphic_git_1.default.addRemote({
                            fs: args.fs,
                            dir: args.dir,
                            remote: args.name,
                            url: args.url,
                            force: args.force,
                        })];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    GitService.prototype.deleteRemote = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, isomorphic_git_1.default.deleteRemote({
                            fs: args.fs,
                            dir: args.dir,
                            remote: args.name,
                        })];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    GitService.prototype.fetch = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b;
            var _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _b = (_a = isomorphic_git_1.default).fetch;
                        _c = {
                            fs: args.fs,
                            http: web_1.default
                        };
                        return [4, this.corsProxy];
                    case 1: return [4, _b.apply(_a, [(_c.corsProxy = _d.sent(),
                                _c.headers = this.getRequestHeaders(args),
                                _c.dir = args.dir,
                                _c.remote = args.remote,
                                _c.ref = args.ref,
                                _c.singleBranch = true,
                                _c.depth = 1,
                                _c.tags = true,
                                _c)])];
                    case 2: return [2, _d.sent()];
                }
            });
        });
    };
    GitService.prototype.checkout = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, isomorphic_git_1.default.checkout({
                            fs: args.fs,
                            dir: args.dir,
                            ref: args.ref,
                            remote: args.remote,
                        })];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    GitService.prototype.checkoutFilesFromLocalHead = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, isomorphic_git_1.default.checkout({
                            fs: args.fs,
                            dir: args.dir,
                            ref: args.ref,
                            filepaths: args.filepaths,
                            noUpdateHead: true,
                            force: true,
                        })];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    GitService.prototype.commit = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!args.author) return [3, 2];
                        return [4, this.setupGitConfig(args.fs, args.dir, args.author)];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [4, isomorphic_git_1.default.commit({
                            fs: args.fs,
                            dir: args.dir,
                            message: args.message,
                            author: {
                                name: args.author.name,
                                email: args.author.email,
                            },
                            ref: args.targetBranch,
                        })];
                    case 3:
                        _a.sent();
                        return [4, isomorphic_git_1.default.writeRef({
                                fs: args.fs,
                                dir: args.dir,
                                ref: "HEAD",
                                force: true,
                                value: args.targetBranch,
                            })];
                    case 4:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    GitService.prototype.pull = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b;
            var _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _b = (_a = isomorphic_git_1.default).pull;
                        _c = {
                            fs: args.fs,
                            http: web_1.default
                        };
                        return [4, this.corsProxy];
                    case 1: return [4, _b.apply(_a, [(_c.corsProxy = _d.sent(),
                                _c.headers = this.getRequestHeaders(args),
                                _c.dir = args.dir,
                                _c.ref = args.ref,
                                _c.singleBranch = true,
                                _c.author = args.author,
                                _c.onAuth = function () { return args.authInfo; },
                                _c)])];
                    case 2:
                        _d.sent();
                        return [2];
                }
            });
        });
    };
    GitService.prototype.deleteBranch = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var currentBranch;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, isomorphic_git_1.default.currentBranch({ fs: args.fs, dir: args.dir })];
                    case 1:
                        currentBranch = _a.sent();
                        if (args.ref === currentBranch) {
                            throw new Error("Can't delete current branch.");
                        }
                        return [4, isomorphic_git_1.default.deleteBranch({
                                fs: args.fs,
                                dir: args.dir,
                                ref: args.ref,
                            })];
                    case 2:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    GitService.prototype.getRemoteRef = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var url, serverRefs, _a, _b;
            var _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0: return [4, isomorphic_git_1.default.getConfig({ fs: args.fs, path: "remote.origin.url", dir: args.dir })];
                    case 1:
                        url = _d.sent();
                        _b = (_a = isomorphic_git_1.default).listServerRefs;
                        _c = {
                            http: web_1.default,
                            url: url
                        };
                        return [4, this.corsProxy];
                    case 2: return [4, _b.apply(_a, [(_c.corsProxy = _d.sent(),
                                _c.headers = this.getRequestHeaders(args),
                                _c.onAuth = function () { return args.authInfo; },
                                _c)])];
                    case 3:
                        serverRefs = _d.sent();
                        return [2, serverRefs.find(function (serverRef) {
                                return args.remoteRef ? serverRef.ref === args.remoteRef : serverRef.ref === "HEAD";
                            })];
                }
            });
        });
    };
    GitService.prototype.push = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var head, serverRemoteRef, _a, _b;
            var _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0: return [4, isomorphic_git_1.default.listRemotes(args)];
                    case 1:
                        if ((_d.sent()).length === 0) {
                            throw new Error("No remote repository found");
                        }
                        return [4, this.resolveRef({
                                fs: args.fs,
                                dir: args.dir,
                                ref: "HEAD",
                            })];
                    case 2:
                        head = _d.sent();
                        return [4, this.getRemoteRef({
                                fs: args.fs,
                                dir: args.dir,
                                remoteRef: args.remoteRef,
                                authInfo: args.authInfo,
                                insecurelyDisableTlsCertificateValidation: args.insecurelyDisableTlsCertificateValidation,
                            })];
                    case 3:
                        serverRemoteRef = _d.sent();
                        if ((serverRemoteRef === null || serverRemoteRef === void 0 ? void 0 : serverRemoteRef.oid) && head === serverRemoteRef.oid)
                            return [2];
                        _b = (_a = isomorphic_git_1.default).push;
                        _c = {
                            fs: args.fs,
                            http: web_1.default
                        };
                        return [4, this.corsProxy];
                    case 4: return [4, _b.apply(_a, [(_c.corsProxy = _d.sent(),
                                _c.headers = this.getRequestHeaders(args),
                                _c.dir = args.dir,
                                _c.ref = args.ref,
                                _c.remoteRef = args.remoteRef,
                                _c.remote = args.remote,
                                _c.force = args.force,
                                _c.onAuth = function () { return args.authInfo; },
                                _c)])];
                    case 5:
                        _d.sent();
                        return [2];
                }
            });
        });
    };
    GitService.prototype.add = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, isomorphic_git_1.default.add({
                            fs: args.fs,
                            dir: args.dir,
                            filepath: args.relativePath,
                        })];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    GitService.prototype.setupGitConfig = function (fs, dir, config) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, isomorphic_git_1.default.setConfig({
                            fs: fs,
                            dir: dir,
                            path: "user.name",
                            value: config.name,
                        })];
                    case 1:
                        _a.sent();
                        return [4, isomorphic_git_1.default.setConfig({
                                fs: fs,
                                dir: dir,
                                path: "user.email",
                                value: config.email,
                            })];
                    case 2:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    GitService.prototype.init = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, isomorphic_git_1.default.init({
                            fs: args.fs,
                            dir: args.dir,
                            bare: false,
                            defaultBranch: GitConstants_1.GIT_DEFAULT_BRANCH,
                        })];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    GitService.prototype.isIgnored = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, isomorphic_git_1.default.isIgnored({
                        fs: args.fs,
                        dir: args.dir,
                        filepath: args.filepath,
                    })];
            });
        });
    };
    GitService.prototype.rm = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, isomorphic_git_1.default.remove({
                            fs: args.fs,
                            dir: args.dir,
                            filepath: args.relativePath,
                        })];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    GitService.prototype.isModified = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var status;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, isomorphic_git_1.default.status({
                            fs: args.fs,
                            dir: args.dir,
                            filepath: args.relativePath,
                        })];
                    case 1:
                        status = _a.sent();
                        return [2, status !== "unmodified"];
                }
            });
        });
    };
    GitService.prototype.hasLocalChanges = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var files;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.unstagedModifiedFilesStatus(args)];
                    case 1:
                        files = _a.sent();
                        return [2, files.length > 0];
                }
            });
        });
    };
    GitService.prototype.unstagedModifiedFilesStatus = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var now, pseudoStatusMatrix, _WORKDIR, _STAGE, _FILE, ret;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        now = performance.now();
                        console.time("".concat(now, ": hasLocalChanges"));
                        return [4, isomorphic_git_1.default.walk({
                                fs: args.fs,
                                dir: args.dir,
                                trees: [(0, isomorphic_git_1.WORKDIR)(), (0, isomorphic_git_1.STAGE)()],
                                map: function (filepath_1, _a) { return __awaiter(_this, [filepath_1, _a], void 0, function (filepath, _b) {
                                    var _c, workdirType, _d, stageType, _e, stageOid, _f, workdirOid, entry, result;
                                    var _g = __read(_b, 2), workdir = _g[0], stage = _g[1];
                                    return __generator(this, function (_h) {
                                        switch (_h.label) {
                                            case 0:
                                                _c = !stage && workdir;
                                                if (!_c) return [3, 2];
                                                return [4, isomorphic_git_1.default.isIgnored({ fs: args.fs, dir: args.dir, filepath: filepath })];
                                            case 1:
                                                _c = (_h.sent());
                                                _h.label = 2;
                                            case 2:
                                                if (_c) {
                                                    return [2, null];
                                                }
                                                if (filepath.startsWith(".git")) {
                                                    return [2, null];
                                                }
                                                if (args.exclude(filepath))
                                                    return [2];
                                                _d = workdir;
                                                if (!_d) return [3, 4];
                                                return [4, workdir.type()];
                                            case 3:
                                                _d = (_h.sent());
                                                _h.label = 4;
                                            case 4:
                                                workdirType = _d;
                                                if (workdirType === "tree" || workdirType === "special")
                                                    return [2];
                                                _e = stage;
                                                if (!_e) return [3, 6];
                                                return [4, stage.type()];
                                            case 5:
                                                _e = (_h.sent());
                                                _h.label = 6;
                                            case 6:
                                                stageType = _e;
                                                if (stageType === "commit")
                                                    return [2, null];
                                                if (stageType === "tree" || stageType === "special")
                                                    return [2];
                                                if (!stage) return [3, 8];
                                                return [4, stage.oid()];
                                            case 7:
                                                _f = _h.sent();
                                                return [3, 9];
                                            case 8:
                                                _f = undefined;
                                                _h.label = 9;
                                            case 9:
                                                stageOid = _f;
                                                if (!(workdir && !stage)) return [3, 10];
                                                workdirOid = "42";
                                                return [3, 12];
                                            case 10:
                                                if (!workdir) return [3, 12];
                                                return [4, workdir.oid()];
                                            case 11:
                                                workdirOid = _h.sent();
                                                _h.label = 12;
                                            case 12:
                                                entry = [undefined, undefined, workdirOid, stageOid];
                                                result = entry.map(function (value) { return entry.indexOf(value); });
                                                result.shift();
                                                return [2, __spreadArray([filepath], __read(result), false)];
                                        }
                                    });
                                }); },
                            })];
                    case 1:
                        pseudoStatusMatrix = _a.sent();
                        _WORKDIR = 2;
                        _STAGE = 3;
                        _FILE = 0;
                        ret = pseudoStatusMatrix
                            .filter(function (row) { return row[_WORKDIR] !== row[_STAGE]; })
                            .map(function (row) {
                            var status;
                            if (row[_WORKDIR] && !row[_STAGE]) {
                                status = FileModificationStatus.added;
                            }
                            else if (!row[_WORKDIR] && row[_STAGE]) {
                                status = FileModificationStatus.deleted;
                            }
                            else {
                                status = FileModificationStatus.modified;
                            }
                            var result = {
                                path: row[_FILE],
                                status: status,
                            };
                            return result;
                        });
                        console.timeEnd("".concat(now, ": hasLocalChanges"));
                        return [2, ret];
                }
            });
        });
    };
    GitService.prototype.resolveRef = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, isomorphic_git_1.default.resolveRef({
                        fs: args.fs,
                        dir: args.dir,
                        ref: args.ref,
                    })];
            });
        });
    };
    return GitService;
}());
exports.GitService = GitService;
//# sourceMappingURL=GitService.js.map