import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useMemo } from "react";
import { DEFAULT_WORKSPACE_ROOT_ABSOLUTE_POSIX_PATH, ChannelType, } from "@kie-tools-core/editor/dist/api";
import { ResourcesList } from "@kie-tools-core/workspace/dist/api";
import { DmnEditorRoot } from "./DmnEditorRoot";
export class DmnEditorFactory {
    createEditor(envelopeContext, initArgs) {
        return Promise.resolve(new DmnEditorInterface(envelopeContext, initArgs));
    }
}
export class DmnEditorInterface {
    constructor(envelopeContext, initArgs) {
        this.envelopeContext = envelopeContext;
        this.initArgs = initArgs;
        this.af_isReact = true;
    }
    getPreview() {
        return this.self.getDiagramSvg();
    }
    async validate() {
        return Promise.resolve([]);
    }
    async setTheme(theme) {
        return Promise.resolve();
    }
    async undo() {
        return this.self.undo();
    }
    async redo() {
        return this.self.redo();
    }
    getContent() {
        return this.self.getContent();
    }
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content) {
        return this.self.setContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content);
    }
    af_componentRoot() {
        var _a, _b;
        return (_jsx(DmnEditorRootWrapper, { exposing: (dmnEditorRoot) => (this.self = dmnEditorRoot), envelopeContext: this.envelopeContext, workspaceRootAbsolutePosixPath: (_a = this.initArgs.workspaceRootAbsolutePosixPath) !== null && _a !== void 0 ? _a : DEFAULT_WORKSPACE_ROOT_ABSOLUTE_POSIX_PATH, isReadOnly: this.initArgs.isReadOnly, channelType: (_b = this.initArgs) === null || _b === void 0 ? void 0 : _b.channel }));
    }
}
export function DmnEditorRootWrapper({ envelopeContext, exposing, workspaceRootAbsolutePosixPath, isEvaluationHighlightsSupported, isReadOnly, channelType, onOpenedBoxedExpressionEditorNodeChange, }) {
    const onNewEdit = useCallback((workspaceEdit) => {
        envelopeContext === null || envelopeContext === void 0 ? void 0 : envelopeContext.channelApi.notifications.kogitoWorkspace_newEdit.send(workspaceEdit);
    }, [envelopeContext]);
    const onRequestWorkspaceFilesList = useCallback(async (resource) => {
        var _a;
        return ((_a = envelopeContext === null || envelopeContext === void 0 ? void 0 : envelopeContext.channelApi.requests.kogitoWorkspace_resourceListRequest(resource)) !== null && _a !== void 0 ? _a : new ResourcesList("", []));
    }, [envelopeContext]);
    const onRequestWorkspaceFileContent = useCallback(async (resource) => {
        return envelopeContext === null || envelopeContext === void 0 ? void 0 : envelopeContext.channelApi.requests.kogitoWorkspace_resourceContentRequest(resource);
    }, [envelopeContext]);
    const onOpenFileFromNormalizedPosixPathRelativeToTheWorkspaceRoot = useCallback((normalizedPosixPathRelativeToTheWorkspaceRoot) => {
        envelopeContext === null || envelopeContext === void 0 ? void 0 : envelopeContext.channelApi.notifications.kogitoWorkspace_openFile.send(normalizedPosixPathRelativeToTheWorkspaceRoot);
    }, [envelopeContext]);
    const isImportDataTypesFromJavaClassesSupported = useMemo(() => channelType === ChannelType.VSCODE_DESKTOP || channelType === ChannelType.VSCODE_WEB, [channelType]);
    const javaCodeCompletionService = useMemo(() => {
        if (isImportDataTypesFromJavaClassesSupported) {
            const { channelApi } = envelopeContext;
            return {
                getFields: (fqcn, query = "") => { var _a; return (_a = channelApi === null || channelApi === void 0 ? void 0 : channelApi.requests) === null || _a === void 0 ? void 0 : _a.kogitoJavaCodeCompletion__getAccessors(fqcn, query); },
                getClasses: (query) => { var _a; return (_a = channelApi === null || channelApi === void 0 ? void 0 : channelApi.requests) === null || _a === void 0 ? void 0 : _a.kogitoJavaCodeCompletion__getClasses(query); },
                isLanguageServerAvailable: () => { var _a; return (_a = channelApi === null || channelApi === void 0 ? void 0 : channelApi.requests) === null || _a === void 0 ? void 0 : _a.kogitoJavaCodeCompletion__isLanguageServerAvailable(); },
            };
        }
    }, [envelopeContext, isImportDataTypesFromJavaClassesSupported]);
    return (_jsx(DmnEditorRoot, { exposing: exposing, onNewEdit: onNewEdit, onRequestWorkspaceFilesList: onRequestWorkspaceFilesList, onRequestWorkspaceFileContent: onRequestWorkspaceFileContent, onOpenFileFromNormalizedPosixPathRelativeToTheWorkspaceRoot: onOpenFileFromNormalizedPosixPathRelativeToTheWorkspaceRoot, onOpenedBoxedExpressionEditorNodeChange: onOpenedBoxedExpressionEditorNodeChange, workspaceRootAbsolutePosixPath: workspaceRootAbsolutePosixPath, keyboardShortcutsService: envelopeContext === null || envelopeContext === void 0 ? void 0 : envelopeContext.services.keyboardShortcuts, isEvaluationHighlightsSupported: isEvaluationHighlightsSupported !== null && isEvaluationHighlightsSupported !== void 0 ? isEvaluationHighlightsSupported : false, isReadOnly: isReadOnly, isImportDataTypesFromJavaClassesSupported: isImportDataTypesFromJavaClassesSupported, javaCodeCompletionService: javaCodeCompletionService }));
}
//# sourceMappingURL=DmnEditorFactory.js.map