import { EditorFactory, EditorInitArgs, KogitoEditorEnvelopeContextType } from "@kie-tools-core/editor/dist/api";
import { DmnEditor } from "../DmnEditor";
import { VsCodeDmnEditorChannelApi } from "./VsCodeDmnEditorChannelApi";
import { JavaCodeCompletionAccessor, JavaCodeCompletionClass } from "@kie-tools-core/vscode-java-code-completion/dist/api";
import { DmnEditorEnvelopeApi } from "../../api";
interface JavaCodeCompletionExposedInteropApi {
    getAccessors(fqcn: string, query: string): Promise<JavaCodeCompletionAccessor[]>;
    getClasses(query: string): Promise<JavaCodeCompletionClass[]>;
    isLanguageServerAvailable(): Promise<boolean>;
}
export interface CustomWindow extends Window {
    envelope: {
        javaCodeCompletionService: JavaCodeCompletionExposedInteropApi;
    };
}
export declare class VsCodeDmnEditorFactory implements EditorFactory<DmnEditor, DmnEditorEnvelopeApi, VsCodeDmnEditorChannelApi> {
    private readonly gwtEditorEnvelopeConfig;
    constructor(gwtEditorEnvelopeConfig: {
        shouldLoadResourcesDynamically: boolean;
    });
    createEditor(ctx: KogitoEditorEnvelopeContextType<DmnEditorEnvelopeApi, VsCodeDmnEditorChannelApi>, initArgs: EditorInitArgs): Promise<DmnEditor>;
}
export {};
//# sourceMappingURL=VsCodeDmnEditorFactory.d.ts.map