import { Notification } from "@kie-tools-core/notifications/dist/api";
declare global {
    interface Window {
        gwtEditorBeans: Map<string, {
            get(): GwtEditor;
        }>;
        appFormerGwtFinishedLoading: () => any;
        erraiBusApplicationRoot: string;
        erraiBusRemoteCommunicationEnabled: boolean;
    }
}
export interface GwtEditor {
    getContent(): Promise<string>;
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    getPreview(): Promise<string | undefined>;
    validate(): Promise<Notification[]>;
    selectStateByName(name: string | null): Promise<void>;
    applyTheme(name: string | null): Promise<void>;
}
export declare class GwtAppFormerConsumedInteropApi {
    onFinishedLoading(callback: () => Promise<any>): void;
    getEditor(editorId: string): GwtEditor;
}
//# sourceMappingURL=GwtAppFormerConsumedInteropApi.d.ts.map