import { GwtEditor } from "./consumedInteropApi/GwtAppFormerConsumedInteropApi";
import { Editor, EditorTheme, KogitoEditorChannelApi } from "@kie-tools-core/editor/dist/api";
import { TextFormatter } from "./TextFormatter";
import { GwtStateControlService } from "./gwtStateControl";
import { MessageBusClientApi } from "@kie-tools-core/envelope-bus/dist/api";
import { I18n } from "@kie-tools-core/i18n/dist/core";
import { KieBcEditorsI18n } from "./i18n";
import { Notification } from "@kie-tools-core/notifications/dist/api";
export declare class GwtEditorWrapper implements Editor {
    readonly af_isReact = true;
    readonly af_componentId = "gwt-editor-wrapper";
    readonly af_componentTitle: string;
    readonly editorId: string;
    private readonly gwtEditor;
    private readonly textFormatter;
    private readonly channelApi;
    private readonly stateControlService;
    private readonly kieBcEditorsI18n;
    normalizedPosixPathRelativeToTheWorkspaceRoot: string;
    constructor(editorId: string, gwtEditor: GwtEditor, channelApi: MessageBusClientApi<KogitoEditorChannelApi>, textFormatter: TextFormatter, stateControlService: GwtStateControlService, kieBcEditorsI18n: I18n<KieBcEditorsI18n>);
    af_onOpen(): void;
    af_componentRoot(): JSX.Element;
    undo(): Promise<void>;
    redo(): Promise<void>;
    getContent(): Promise<string>;
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    selectStateByName(name: string | null): Promise<void>;
    getPreview(): Promise<string | undefined>;
    validate(): Promise<Notification[]>;
    setTheme(theme: EditorTheme): Promise<void>;
    private removeBusinessCentralHeaderPanel;
    private removeBusinessCentralPanelHeader;
    private removeHeaderIfOnlyOneItemOnTable;
    private injectStyleToFixResponsivenessIssue_DROOLS_3995;
}
//# sourceMappingURL=GwtEditorWrapper.d.ts.map