import { BpmnEditorChannelApi, BpmnEditorEnvelopeApi } from "../api";
import { EditorFactory, EditorInitArgs, KogitoEditorEnvelopeApi, KogitoEditorEnvelopeContextType } from "@kie-tools-core/editor/dist/api";
import { BpmnEditor } from "./BpmnEditor";
import { DmnLanguageServiceExposedInteropApi } from "./exposedInteropApi/DmnLanguageServiceExposedInteropApi";
export interface CustomWindow extends Window {
    envelope: {
        dmnLanguageService: DmnLanguageServiceExposedInteropApi;
    };
}
export declare class BpmnEditorFactory implements EditorFactory<BpmnEditor, BpmnEditorEnvelopeApi, BpmnEditorChannelApi> {
    private readonly gwtEditorEnvelopeConfig;
    constructor(gwtEditorEnvelopeConfig: {
        shouldLoadResourcesDynamically: boolean;
    });
    createEditor(ctx: KogitoEditorEnvelopeContextType<KogitoEditorEnvelopeApi, BpmnEditorChannelApi>, initArgs: EditorInitArgs): Promise<BpmnEditor>;
}
//# sourceMappingURL=BpmnEditorFactory.d.ts.map