import { By } from "selenium-webdriver";
import PageFrament from "../PageFragment";
class Properties extends PageFrament {
    async waitUntilLoaded() {
        return await this.tools.by(Properties.LABEL_LOCATOR).wait(1000).untilPresent();
    }
    getProperty(type, nameAttributeSuffix) {
        return By.xpath(`//${type}[contains(@name, '${nameAttributeSuffix}')]`);
    }
    async getValue(type, nameAttributeSuffix) {
        return await this.tools.by(this.getProperty(type, nameAttributeSuffix)).wait(2000).untilHasValue();
    }
    async getNameFromTextArea() {
        return await this.getValue("textarea", ".general.name");
    }
    async getProcessNameFromInput() {
        return await this.getValue("input", "diagramSet.name");
    }
    async getDmnNameFromInput() {
        return await this.getValue("input", ".nameHolder");
    }
}
Properties.LABEL_LOCATOR = By.xpath("//h3[text()='Properties']");
export default Properties;
//# sourceMappingURL=Properties.js.map