import { ActionMap, Actions, AllActions } from "./Actions";
import { HistoryAwareValidatingReducer } from "../history";
import { MiningSchema } from "@kie-tools/pmml-editor-marshaller";
interface MiningSchemaPayload {
    [Actions.AddMiningSchemaFields]: {
        readonly modelIndex: number;
        readonly names: string[];
    };
    [Actions.DeleteMiningSchemaField]: {
        readonly modelIndex: number;
        readonly miningSchemaIndex: number;
        readonly name?: string;
    };
}
export type MiningSchemaActions = ActionMap<MiningSchemaPayload>[keyof ActionMap<MiningSchemaPayload>];
export declare const MiningSchemaReducer: HistoryAwareValidatingReducer<MiningSchema, AllActions>;
export {};
//# sourceMappingURL=MiningSchemaReducer.d.ts.map