import { Actions } from "./Actions";
import { Characteristic } from "@kie-tools/pmml-editor-marshaller";
import { AttributesReducer } from "./AttributesReducer";
import { immerable } from "immer";
import { Builder } from "../paths";
Characteristic[immerable] = true;
export const CharacteristicReducer = (historyService) => {
    const attributesReducer = AttributesReducer(historyService);
    const delegateToAttributes = (state, action) => {
        switch (action.type) {
            case Actions.Scorecard_AddAttribute:
            case Actions.Scorecard_UpdateAttribute:
            case Actions.Scorecard_DeleteAttribute:
                const characteristicIndex = action.payload.characteristicIndex;
                const attributes = state[characteristicIndex].Attribute;
                attributesReducer(attributes, action);
        }
        return state;
    };
    return (state, action) => {
        switch (action.type) {
            case Actions.Scorecard_UpdateCharacteristic:
                historyService.batch(state, Builder().forModel(action.payload.modelIndex).forCharacteristics().forCharacteristic().build(), (draft) => {
                    const characteristicIndex = action.payload.characteristicIndex;
                    if (characteristicIndex >= 0 && characteristicIndex < draft.length) {
                        draft[characteristicIndex] = {
                            ...draft[characteristicIndex],
                            name: action.payload.name,
                            reasonCode: action.payload.reasonCode,
                            baselineScore: action.payload.baselineScore,
                        };
                    }
                    if (action.payload.reasonCode !== undefined) {
                        draft[characteristicIndex].Attribute.forEach((attribute) => (attribute.reasonCode = undefined));
                    }
                });
                return state;
        }
        return delegateToAttributes(state, action);
    };
};
//# sourceMappingURL=CharacteristicReducer.js.map