import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Chart, ChartAxis, ChartGroup, ChartLabel, ChartLine, ChartVoronoiContainer } from "@patternfly/react-charts";
export class Line {
    constructor(m, c, title) {
        this.m = m;
        this.c = c;
        this.title = title;
    }
}
export class Range {
    constructor(min, max) {
        this.min = min;
        this.max = max;
    }
}
const roundedToFixed = (_float, _digits) => {
    const rounded = Math.pow(10, _digits);
    return (Math.round(_float * rounded) / rounded).toFixed(_digits);
};
const getTicks = (range, count) => {
    const start = range.min;
    const end = range.max;
    const step = (end - start) / count;
    const ticks = new Array();
    let v = start;
    while (v <= end) {
        ticks.push(v);
        v = v + step;
    }
    if (ticks[ticks.length - 1] !== end) {
        ticks.push(end);
    }
    return ticks;
};
export const LinearRegressionView = (props) => {
    const legendData = [];
    props.lines.forEach((line) => {
        legendData.push({ name: line.title });
    });
    const { modelName = "undefined", width = 500, height = 500 } = props;
    return (_jsx("div", { style: { height: height, width: width }, children: _jsxs(Chart, { ariaTitle: modelName, containerComponent: _jsx(ChartVoronoiContainer, { labels: ({ datum }) => `${roundedToFixed(datum._x, 2)}, ${roundedToFixed(datum._y, 2)}`, constrainToVisibleArea: true }), legendData: legendData, legendOrientation: "horizontal", legendPosition: "bottom", padding: {
                bottom: 100,
                left: 50,
                right: 50,
                top: 50,
            }, height: height, width: width, children: [_jsx(ChartLabel, { text: modelName, x: width / 2, y: 30, textAnchor: "middle" }), _jsx(ChartAxis, { label: props.independentAxisTitle, showGrid: true, tickValues: getTicks(props.rangeX, 8), tickFormat: (x) => roundedToFixed(x, 2) }), _jsx(ChartAxis, { label: props.dependentAxisTitle, dependentAxis: true, showGrid: true, tickValues: getTicks(props.rangeY, 8), tickFormat: (x) => roundedToFixed(x, 2) }), _jsx(ChartGroup, { children: props.lines.map((line) => {
                        return (_jsx(ChartLine, { samples: 100, domain: {
                                x: [props.rangeX.min, props.rangeX.max],
                                y: [props.rangeY.min, props.rangeY.max],
                            }, y: (datum) => line.m * datum.x + line.c }, line.title));
                    }) })] }) }));
};
//# sourceMappingURL=LinearRegressionView.js.map