import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Card, CardBody, CardFooter, CardHeader, CardHeaderMain, CardTitle, } from "@patternfly/react-core/dist/js/components/Card";
import { useCallback, useMemo } from "react";
import "./ModelCard.scss";
import { ModelCardIcon } from "../atoms";
import { MODEL_NAME_NOT_SET } from "../../EditorCore/atoms";
export const ModelCard = (props) => {
    const { index, modelName, modelType } = props;
    const onClickModel = useCallback((e) => {
        if (index !== undefined) {
            e.stopPropagation();
            props.onClick(index);
        }
    }, [index]);
    const onDeleteModel = useCallback((e) => {
        if (index !== undefined) {
            e.stopPropagation();
            props.onDelete(index);
        }
    }, [index]);
    const _modelName = useMemo(() => (modelName === "" ? MODEL_NAME_NOT_SET : modelName), [modelName]);
    return (_jsxs(Card, { "data-testid": "model-card", isHoverable: true, className: "model-card", onClick: onClickModel, children: [_jsx(CardHeader, { children: _jsx(CardHeaderMain, { children: _jsx(ModelCardIcon, { type: modelType }) }) }), _jsx(Tooltip, { content: _jsx("div", { children: _modelName }), children: _jsx(CardTitle, { className: "model-card__title", children: _jsx("span", { "data-testid": "model-card__title", children: _modelName }) }) }), " ", _jsx(CardBody, { children: _jsx("div", { "data-testid": "model-card__model-type", children: modelType }) }), _jsx(CardFooter, { children: _jsx(Button, { "data-testid": "model-card__delete", variant: "primary", onClick: onDeleteModel, children: "Delete" }) })] }));
};
//# sourceMappingURL=ModelCard.js.map