import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useMemo } from "react";
import { PageSection, PageSectionVariants } from "@patternfly/react-core/dist/js/components/Page";
import { EditorHeader } from "../../EditorCore/molecules";
import { Scorecard, } from "@kie-tools/pmml-editor-marshaller";
import { CharacteristicsContainer, CorePropertiesTable } from "../organisms";
import { getModelName } from "../../..";
import { Actions } from "../../../reducers";
import { useSelector } from "react-redux";
import "./ScorecardEditorPage.scss";
import { EmptyStateModelNotFound } from "../../EditorCore/organisms";
import { useBatchDispatch, useHistoryService } from "../../../history";
export const ScorecardEditorPage = (props) => {
    var _a, _b, _c, _d, _e, _f;
    const { modelIndex } = props;
    const { service, getCurrentState } = useHistoryService();
    const dispatch = useBatchDispatch(service, getCurrentState);
    const model = useSelector((state) => {
        const _model = state.models ? state.models[props.modelIndex] : undefined;
        if (_model && _model instanceof Scorecard) {
            return _model;
        }
        return undefined;
    });
    const modelName = useMemo(() => getModelName(model), [model]);
    const characteristics = useMemo(() => model === null || model === void 0 ? void 0 : model.Characteristics, [model]);
    const miningSchema = useMemo(() => model === null || model === void 0 ? void 0 : model.MiningSchema, [model]);
    const output = useMemo(() => model === null || model === void 0 ? void 0 : model.Output, [model]);
    const validateOutputName = useCallback((index, name) => {
        var _a;
        if (name.toString().trim().length === 0) {
            return false;
        }
        const existing = (_a = output === null || output === void 0 ? void 0 : output.OutputField) !== null && _a !== void 0 ? _a : [];
        const matching = existing.filter((c, _index) => _index !== index && c.name === name);
        return matching.length === 0;
    }, [output]);
    const isBaselineScoreDisabled = useMemo(() => {
        return ((characteristics === null || characteristics === void 0 ? void 0 : characteristics.Characteristic) !== undefined &&
            characteristics.Characteristic.length > 0 &&
            characteristics.Characteristic.every((characteristic) => characteristic.baselineScore !== undefined));
    }, [characteristics]);
    const onDeleteOutputField = useCallback((_index) => {
        dispatch({
            type: Actions.DeleteOutput,
            payload: {
                modelIndex: modelIndex,
                outputIndex: _index,
            },
        });
    }, [modelIndex, output]);
    const onUpdateOutputField = useCallback((_index, _outputField) => {
        if (_index === undefined) {
            dispatch({
                type: Actions.AddOutput,
                payload: {
                    modelIndex: modelIndex,
                    outputField: _outputField,
                },
            });
        }
        else {
            dispatch({
                type: Actions.UpdateOutput,
                payload: {
                    modelIndex: modelIndex,
                    outputIndex: _index,
                    outputField: _outputField,
                },
            });
        }
    }, [modelIndex]);
    const onUpdateModelName = useCallback((_modelName) => {
        if (_modelName !== modelName) {
            dispatch({
                type: Actions.Scorecard_SetModelName,
                payload: {
                    modelIndex: modelIndex,
                    modelName: _modelName === "" ? undefined : _modelName,
                },
            });
        }
    }, [modelIndex]);
    const onUpdateCoreProperty = useCallback((_props) => {
        dispatch({
            type: Actions.Scorecard_SetCoreProperties,
            payload: {
                modelIndex: modelIndex,
                isScorable: _props.isScorable,
                functionName: _props.functionName,
                algorithmName: _props.algorithmName,
                baselineScore: _props.baselineScore,
                baselineMethod: _props.baselineMethod,
                initialScore: _props.initialScore,
                useReasonCodes: _props.areReasonCodesUsed,
                reasonCodeAlgorithm: _props.reasonCodeAlgorithm,
            },
        });
    }, [modelIndex]);
    return (_jsxs("div", { "data-testid": "editor-page", className: "editor", children: [!model && _jsx(EmptyStateModelNotFound, {}), model && (_jsxs(_Fragment, { children: [_jsx("div", { className: "editor__header__container", children: _jsx("div", { className: "editor__header__content", children: _jsx(PageSection, { variant: PageSectionVariants.light, isFilled: false, children: _jsx(EditorHeader, { modelName: modelName, modelIndex: modelIndex, miningSchema: miningSchema, output: output, validateOutputFieldName: validateOutputName, deleteOutputField: onDeleteOutputField, commitOutputField: onUpdateOutputField, commitModelName: onUpdateModelName }) }) }) }), _jsx("div", { className: "editor__body__container", children: _jsxs("div", { className: "editor__body__content", children: [_jsx(PageSection, { isFilled: false, "data-ouia-component-id": "model-setup", children: _jsx(CorePropertiesTable, { modelIndex: modelIndex, isScorable: (_a = model.isScorable) !== null && _a !== void 0 ? _a : true, functionName: model.functionName, algorithmName: model.algorithmName, baselineScore: model.baselineScore, isBaselineScoreDisabled: isBaselineScoreDisabled, baselineMethod: (_b = model.baselineMethod) !== null && _b !== void 0 ? _b : "other", initialScore: model.initialScore, areReasonCodesUsed: (_c = model.useReasonCodes) !== null && _c !== void 0 ? _c : true, reasonCodeAlgorithm: (_d = model.reasonCodeAlgorithm) !== null && _d !== void 0 ? _d : "pointsBelow", commit: onUpdateCoreProperty }) }), _jsx(PageSection, { isFilled: true, style: { paddingTop: "0px" }, children: _jsx(PageSection, { variant: PageSectionVariants.light, style: { height: "100%" }, children: _jsx(CharacteristicsContainer, { modelIndex: modelIndex, areReasonCodesUsed: (_e = model.useReasonCodes) !== null && _e !== void 0 ? _e : true, scorecardBaselineScore: model.baselineScore, characteristics: (_f = characteristics === null || characteristics === void 0 ? void 0 : characteristics.Characteristic) !== null && _f !== void 0 ? _f : [] }) }) })] }) })] }))] }));
};
//# sourceMappingURL=ScorecardEditorPage.js.map