import { jsx as _jsx } from "react/jsx-runtime";
import { useRef } from "react";
import MonacoEditor from "react-monaco-editor";
import { bootstrapMonaco } from "./PredicateEditorSetup";
bootstrapMonaco();
export const PredicateEditor = (props) => {
    const { text, setText } = props;
    const monaco = useRef(null);
    const editorDidMount = (editor) => {
        editor.focus();
    };
    return (_jsx(MonacoEditor, { ref: monaco, height: "300px", language: "scorecards", theme: "scorecards", options: {
            glyphMargin: false,
            scrollBeyondLastLine: false,
        }, value: text !== null && text !== void 0 ? text : "", onChange: (e) => setText(e), editorDidMount: editorDidMount }));
};
//# sourceMappingURL=PredicateEditor.js.map