import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { useValidationRegistry } from "../../../validation";
import { AttributeLabel } from "./AttributeLabel";
import { ValidationIndicatorLabel } from "../../EditorCore/atoms";
import { Builder } from "../../../paths";
export const AttributeLabels = (props) => {
    const { modelIndex, characteristic, characteristicIndex, activeAttributeIndex, activeAttribute, areReasonCodesUsed, characteristicReasonCode, commit, } = props;
    const { validationRegistry } = useValidationRegistry();
    const reasonCodeValidation = useMemo(() => validationRegistry.get(Builder()
        .forModel(modelIndex)
        .forCharacteristics()
        .forCharacteristic(characteristicIndex)
        .forAttribute(activeAttributeIndex)
        .forReasonCode()
        .build()), [
        modelIndex,
        characteristicIndex,
        areReasonCodesUsed,
        activeAttribute,
        activeAttributeIndex,
        characteristicReasonCode,
    ]);
    const partialScoreValidation = useMemo(() => validationRegistry.get(Builder()
        .forModel(modelIndex)
        .forCharacteristics()
        .forCharacteristic(characteristicIndex)
        .forAttribute(activeAttributeIndex)
        .forPartialScore()
        .build()), [modelIndex, characteristicIndex, characteristic, activeAttribute, activeAttributeIndex]);
    return (_jsxs(_Fragment, { children: [areReasonCodesUsed && activeAttribute.reasonCode !== undefined && reasonCodeValidation.length === 0 && (_jsxs(_Fragment, { children: [commit && (_jsx(AttributeLabel, { name: "Reason code", value: activeAttribute.reasonCode, onClose: () => commit({ reasonCode: undefined }) })), !commit && _jsx(AttributeLabel, { name: "Reason code", value: activeAttribute.reasonCode })] })), areReasonCodesUsed && reasonCodeValidation.length > 0 && (_jsx(ValidationIndicatorLabel, { validations: reasonCodeValidation, cssClass: "characteristic-list__item__label", children: _jsxs(_Fragment, { children: [_jsx("strong", { children: "Reason code:" }), "\u00A0", _jsx("em", { children: "Missing" })] }) })), partialScoreValidation.length === 0 && activeAttribute.partialScore !== undefined && (_jsxs(_Fragment, { children: [commit && (_jsx(AttributeLabel, { name: "Partial score", value: activeAttribute.partialScore, onClose: () => commit({ partialScore: undefined }) })), !commit && _jsx(AttributeLabel, { name: "Partial score", value: activeAttribute.partialScore })] })), partialScoreValidation.length > 0 && (_jsx(ValidationIndicatorLabel, { validations: partialScoreValidation, cssClass: "characteristic-list__item__label", children: _jsxs(_Fragment, { children: [_jsx("strong", { children: "Partial score:" }), "\u00A0", _jsx("em", { children: "Missing" })] }) }))] }));
};
//# sourceMappingURL=AttributeLabels.js.map