import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useParams } from "react-router-dom";
import { ScorecardEditorPage } from "../../EditorScorecard/templates";
import { getModelType, isSupportedModelType } from "../../..";
import { useSelector } from "react-redux";
import { EmptyStateModelNotFound } from ".";
import { UnsupportedModelPage } from "../templates";
import { Operation, useOperation } from "../../EditorScorecard";
import { LinearRegressionViewerPage } from "../../LinearRegressionViewer/templates";
export const SingleEditorRouter = (props) => {
    const { index } = useParams();
    const { setActiveOperation } = useOperation();
    const models = useSelector((state) => state.models);
    if (!models) {
        return _jsx(EmptyStateModelNotFound, {});
    }
    const _index = index ? +index : -1;
    if (isNaN(_index) || _index < 0 || _index > models.length - 1) {
        return _jsx(EmptyStateModelNotFound, {});
    }
    const model = models[_index];
    const modelType = getModelType(model);
    const _isSupportedModelType = isSupportedModelType(model);
    return (_jsxs("div", { tabIndex: -1, onKeyDown: (e) => {
            if (e.key === "Escape") {
                setActiveOperation(Operation.NONE);
            }
        }, children: [!_isSupportedModelType && _jsx(UnsupportedModelPage, { path: props.path, model: model }), _isSupportedModelType && modelType === "Scorecard" && (_jsx(ScorecardEditorPage, { path: props.path, modelIndex: _index })), _isSupportedModelType && modelType === "Regression Model" && (_jsx(LinearRegressionViewerPage, { path: props.path, modelIndex: _index }))] }));
};
//# sourceMappingURL=SingleEditorRouter.js.map