import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { every } from "lodash";
import { ConstraintType } from "../DataDictionaryContainer/DataDictionaryContainer";
import { ValidationIndicatorLabel } from "../../EditorCore/atoms";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
import "./ConstraintsLabel.scss";
const ConstraintsLabel = (props) => {
    const { dataType, dataTypeIndex, editMode = false, onConstraintsDelete } = props;
    const onClose = useMemo(() => {
        if (editMode && !areConstraintsRequired(dataType)) {
            return (event) => {
                event.nativeEvent.stopImmediatePropagation();
                onConstraintsDelete === null || onConstraintsDelete === void 0 ? void 0 : onConstraintsDelete();
            };
        }
    }, [dataTypeIndex, dataType]);
    const missingRequiredConstraints = useMemo(() => {
        return !dataType.constraints && areConstraintsRequired(dataType);
    }, [dataType]);
    const constraintValue = useMemo(() => {
        if (dataType.constraints) {
            switch (dataType.constraints.type) {
                case ConstraintType.RANGE:
                    return dataType.constraints.value
                        .map((range) => {
                        return (`${range.start.included ? "[" : "("}` +
                            `${range.start.value || `${String.fromCharCode(8722, 8734)}`}, ` +
                            `${range.end.value || `${String.fromCharCode(43, 8734)}`}` +
                            `${range.end.included ? "]" : ")"}`);
                    })
                        .join(" ");
                case ConstraintType.ENUMERATION:
                    if (every(dataType.constraints.value, (value) => value === "")) {
                        return _jsx("em", { children: "No values" });
                    }
                    return dataType.constraints.value.map((item) => `"${item}"`).join(", ");
                default:
                    return "";
            }
        }
        return "";
    }, [dataType.constraints]);
    const { validationRegistry } = useValidationRegistry();
    const validations = useMemo(() => validationRegistry.get(Builder().forDataDictionary().forDataField(dataTypeIndex).build()), [dataTypeIndex, dataType]);
    return (_jsxs(_Fragment, { children: [missingRequiredConstraints && (_jsx(ValidationIndicatorLabel, { validations: validations, cssClass: "constraints-label", children: _jsx("em", { children: "Missing required constraints" }) })), !missingRequiredConstraints && dataType.constraints && (_jsxs(_Fragment, { children: [validations.length > 0 && (_jsx(ValidationIndicatorLabel, { validations: validations, onClose: onClose, cssClass: "constraints-label", "data-ouia-component-id": "invalid-constraints", "data-ouia-component-type": "data-props-label", children: _jsxs(_Fragment, { children: [_jsx("strong", { children: "Constraints:" }), "\u00A0", _jsx("span", { children: constraintValue })] }) })), validations.length === 0 && (_jsxs(Label, { color: "cyan", className: "constraints-label", onClose: onClose, "data-ouia-component-id": "constraints", "data-ouia-component-type": "data-props-label", children: [_jsx("strong", { children: "Constraints:" }), "\u00A0", _jsx("span", { children: constraintValue })] }))] }))] }));
};
export default ConstraintsLabel;
const areConstraintsRequired = (dataType) => {
    return dataType.isCyclic || (dataType.type === "string" && dataType.optype === "ordinal");
};
//# sourceMappingURL=ConstraintsLabel.js.map