import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useMemo, useState } from "react";
import { Card, CardBody } from "@patternfly/react-core/dist/js/components/Card";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Select, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { HelpIcon } from "@patternfly/react-icons/dist/js/icons/help-icon";
import { ConstraintType } from "../DataDictionaryContainer/DataDictionaryContainer";
import ConstraintsRangeEdit from "../ConstraintsRangeEdit/ConstraintsRangeEdit";
import ConstraintsEnumEdit from "../ConstraintsEnumEdit/ConstraintsEnumEdit";
import "./ConstraintsEdit.scss";
const ConstraintsEdit = (props) => {
    var _a, _b, _c, _d;
    const { dataType, dataFieldIndex, onSave } = props;
    const [constraintType, setConstraintType] = useState((_b = (_a = dataType.constraints) === null || _a === void 0 ? void 0 : _a.type) !== null && _b !== void 0 ? _b : "");
    const [typeSelectIsOpen, setTypeSelectIsOpen] = useState(false);
    const { typeOptions, enabledTypeOptionsCount } = useMemo(() => getConstraintsTypeOptions(dataType), [dataType]);
    const typeDescription = useMemo(() => getConstraintsTypeDescription(dataType), [dataType]);
    const [ranges, setRanges] = useState(((_c = dataType.constraints) === null || _c === void 0 ? void 0 : _c.type) === ConstraintType.RANGE ? dataType.constraints.value : undefined);
    const [enums, setEnums] = useState(((_d = dataType.constraints) === null || _d === void 0 ? void 0 : _d.type) === ConstraintType.ENUMERATION ? dataType.constraints.value : undefined);
    const rangeConstraintLimit = useMemo(() => (dataType.optype === "continuous" && dataType.isCyclic ? 1 : undefined), [dataType]);
    const handleTypeChange = (event, value) => {
        if (value !== constraintType) {
            setConstraintType(value);
            if (value === ConstraintType.RANGE) {
                onSave({
                    constraints: {
                        type: ConstraintType.RANGE,
                        value: [
                            {
                                start: {
                                    value: "",
                                    included: true,
                                },
                                end: {
                                    value: "",
                                    included: true,
                                },
                            },
                        ],
                    },
                });
            }
            if (value === ConstraintType.ENUMERATION) {
                onSave({
                    constraints: {
                        type: ConstraintType.ENUMERATION,
                        value: [""],
                    },
                });
            }
            if (value === "") {
                onSave({
                    constraints: undefined,
                });
            }
        }
        setTypeSelectIsOpen(false);
    };
    const handleTypeToggle = () => {
        setTypeSelectIsOpen(!typeSelectIsOpen);
    };
    const handleRangeSave = (updatedRanges) => {
        onSave({
            constraints: {
                type: ConstraintType.RANGE,
                value: updatedRanges,
            },
        });
    };
    const handleRangeAdd = () => {
        const updatedRanges = [...(ranges !== null && ranges !== void 0 ? ranges : [])];
        updatedRanges.push({
            start: {
                value: "",
                included: true,
            },
            end: {
                value: "",
                included: true,
            },
        });
        onSave({
            constraints: {
                type: ConstraintType.RANGE,
                value: updatedRanges,
            },
        });
    };
    const handleRangeDelete = (index) => {
        const updatedRanges = [...(ranges !== null && ranges !== void 0 ? ranges : [])];
        updatedRanges.splice(index, 1);
        onSave({
            constraints: {
                type: ConstraintType.RANGE,
                value: updatedRanges,
            },
        });
    };
    const handleEnumsChange = (value, index) => {
        const updatedEnums = [...(enums !== null && enums !== void 0 ? enums : [])];
        updatedEnums[index] = value;
        onSave({
            constraints: {
                type: ConstraintType.ENUMERATION,
                value: updatedEnums,
            },
        });
    };
    const handleEnumsDelete = (index) => {
        const updatedEnums = [...(enums !== null && enums !== void 0 ? enums : [])];
        updatedEnums.splice(index, 1);
        onSave({
            constraints: {
                type: ConstraintType.ENUMERATION,
                value: updatedEnums,
            },
        });
    };
    const handleAddEnum = () => {
        const updatedEnums = [...(enums !== null && enums !== void 0 ? enums : []), ""];
        onSave({
            constraints: {
                type: ConstraintType.ENUMERATION,
                value: updatedEnums,
            },
        });
    };
    const handleEnumSort = (oldIndex, newIndex) => {
        if (enums) {
            const updatedEnums = reorderArray(enums, oldIndex, newIndex);
            onSave({
                constraints: {
                    type: ConstraintType.ENUMERATION,
                    value: updatedEnums,
                },
            });
        }
    };
    useEffect(() => {
        var _a, _b, _c, _d;
        setConstraintType((_b = (_a = dataType.constraints) === null || _a === void 0 ? void 0 : _a.type) !== null && _b !== void 0 ? _b : "");
        if (((_c = dataType.constraints) === null || _c === void 0 ? void 0 : _c.type) === ConstraintType.RANGE) {
            setRanges(dataType.constraints.value);
        }
        if (((_d = dataType.constraints) === null || _d === void 0 ? void 0 : _d.type) === ConstraintType.ENUMERATION) {
            setEnums(dataType.constraints.value);
        }
    }, [dataType.constraints]);
    return (_jsxs("section", { className: "constraints__form", children: [_jsx(FormGroup, { fieldId: "constraints-type", label: "Constraints Type", helperText: enabledTypeOptionsCount > 1 ? "Select the type of constraint and then fill in the required fields." : "", labelIcon: typeDescription.length > 0 ? (_jsx(Tooltip, { content: typeDescription, children: _jsx("button", { "aria-label": "More info for Constraints Type", onClick: (e) => e.preventDefault(), "aria-describedby": "constraints-type", className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) })) : (_jsx(_Fragment, {})), children: _jsx("div", { style: { width: 300 }, children: _jsx(Select, { id: "constraints-type", variant: SelectVariant.single, "aria-label": "Select Constraint Type", onToggle: handleTypeToggle, onSelect: handleTypeChange, selections: constraintType, isOpen: typeSelectIsOpen, placeholderText: "Select a type", isDisabled: enabledTypeOptionsCount === 1, ouiaId: "constraints-type", children: typeOptions.map((item, index) => (_jsx(SelectOption, { value: item.value, isDisabled: item.disabled, "data-ouia-component-type": "select-option", children: item.label }, index))) }) }) }), constraintType === ConstraintType.RANGE && ranges !== undefined && (_jsx(Card, { isCompact: true, className: "constraints__card", children: _jsx(CardBody, { children: _jsx(ConstraintsRangeEdit, { dataFieldIndex: dataFieldIndex, ranges: ranges, onAdd: handleRangeAdd, onChange: handleRangeSave, onDelete: handleRangeDelete, countLimit: rangeConstraintLimit }) }) })), constraintType === ConstraintType.ENUMERATION && enums !== undefined && (_jsx(Card, { isCompact: true, className: "constraints__card", children: _jsx(CardBody, { children: _jsx(ConstraintsEnumEdit, { dataFieldIndex: dataFieldIndex, enumerations: enums, onChange: handleEnumsChange, onDelete: handleEnumsDelete, onAdd: handleAddEnum, onSort: handleEnumSort }) }) }))] }));
};
export default ConstraintsEdit;
const reorderArray = (list, startIndex, endIndex) => {
    const result = [...list];
    const [removed] = result.splice(startIndex, 1);
    result.splice(endIndex, 0, removed);
    return result;
};
const getConstraintsTypeOptions = (dataType) => {
    const typeOptions = [
        { value: ConstraintType.NONE, label: "Select a type", disabled: false },
        { value: ConstraintType.RANGE, label: "Interval", disabled: false },
        { value: ConstraintType.ENUMERATION, label: "Value", disabled: false },
    ];
    if (dataType.type === "string" && dataType.optype === "ordinal") {
        typeOptions[0].disabled = true;
        typeOptions[1].disabled = true;
    }
    if (dataType.optype !== "continuous") {
        typeOptions[1].disabled = true;
    }
    if (dataType.isCyclic) {
        typeOptions[0].disabled = true;
    }
    const enabledTypeOptionsCount = typeOptions.filter((option) => !option.disabled).length;
    return { typeOptions, enabledTypeOptionsCount };
};
const getConstraintsTypeDescription = (dataType) => {
    if (dataType.optype === "ordinal" && dataType.isCyclic) {
        return "Cyclic ordinal data types must have Value constraints";
    }
    if (dataType.optype === "continuous" && dataType.isCyclic) {
        return "Cyclic continuous data types must have constraints";
    }
    if (dataType.type === "string" && dataType.optype === "ordinal") {
        return "Ordinal strings must have Value constraints";
    }
    if (dataType.optype !== "continuous") {
        return "Only continuous data types can have Interval constraints";
    }
    return "";
};
//# sourceMappingURL=ConstraintsEdit.js.map