import * as React from "react";
import { Operation } from "./components/EditorScorecard";
import { WorkspaceEdit } from "@kie-tools-core/workspace/dist/api";
import { Notification } from "@kie-tools-core/notifications/dist/api";
interface Props {
    exposing: (s: PMMLEditor) => void;
    ready: () => void;
    newEdit: (edit: WorkspaceEdit) => void;
    setNotifications: (normalizedPosixPathRelativeToTheWorkspaceRoot: string, notifications: Notification[]) => void;
}
export interface State {
    path: string;
    content: string;
    originalContent: string;
    activeOperation: Operation;
}
export declare class PMMLEditor extends React.Component<Props, State> {
    private store;
    private readonly history;
    private readonly validationRegistry;
    private readonly reducer;
    constructor(props: Props);
    componentDidMount(): void;
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    private doSetContent;
    getContent(): Promise<string>;
    private doGetContent;
    undo(): Promise<void>;
    private doUndo;
    redo(): Promise<void>;
    private doRedo;
    validate(): Notification[];
    private isSingleModel;
    render(): JSX.Element;
}
export {};
//# sourceMappingURL=PMMLEditor.d.ts.map