import { ApolloClient } from "apollo-client";
import { UserTaskInstance } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { User } from "@kie-tools/runtime-tools-components/dist/contexts/KogitoAppContext";
import { QueryFilter, SortBy } from "@kie-tools/runtime-tools-process-enveloped-components/src/taskInbox";
export interface TaskInboxQueries {
    getUserTaskById(taskId: string): Promise<UserTaskInstance | undefined>;
    getUserTasks(user: User, start: number, end: number, filters: QueryFilter, sortBy: SortBy): Promise<UserTaskInstance[]>;
    getAllTasks(start: number, end: number, filters: QueryFilter, sortBy: SortBy): Promise<UserTaskInstance[]>;
}
export declare class GraphQLTaskInboxQueries implements TaskInboxQueries {
    private readonly client;
    constructor(client: ApolloClient<any>);
    getUserTaskById(taskId: string): Promise<UserTaskInstance | undefined>;
    getUserTasks(user: User, offset: number, limit: number, filters: QueryFilter, sortBy: SortBy): Promise<UserTaskInstance[]>;
    getAllTasks(offset: number, limit: number, filters: QueryFilter, sortBy: SortBy): Promise<UserTaskInstance[]>;
}
//# sourceMappingURL=TaskInboxQueries.d.ts.map