import { UserTaskInstance, UserTaskTransitionInfo } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { User } from "@kie-tools/runtime-tools-components/dist/contexts/KogitoAppContext";
import { Form } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
export interface TaskFormGatewayApi {
    getTaskFormSchema(userTask: UserTaskInstance, headers?: any): Promise<Record<string, any>>;
    getCustomForm(userTask: UserTaskInstance, headers?: any): Promise<Form>;
    doSubmit(userTask: UserTaskInstance, phase: string, payload: any, headers?: any): Promise<any>;
    getTaskPhases(userTask: UserTaskInstance, headers?: any): Promise<string[]>;
}
export declare class TaskFormGatewayApiImpl implements TaskFormGatewayApi {
    private readonly getCurrentUser;
    private transformEndpointBaseUrl;
    constructor(getCurrentUser: () => User, transformEndpointBaseUrl: (url: string) => string);
    submitTaskForm(endpoint: string, transition: UserTaskTransitionInfo, headers?: any): Promise<any>;
    fetchTaskFormSchema(endpoint: string, headers?: any): Promise<Record<string, any>>;
    fetchCustomForm(endpoint: string, headers?: any): Promise<Form>;
    fetchTaskTransitionPhases(endpoint: string, headers?: any): Promise<string[]>;
    doSubmit(userTask: UserTaskInstance, phase: string, payload: any, headers?: any): Promise<any>;
    getTaskFormSchema(userTask: UserTaskInstance, headers?: any): Promise<Record<string, any>>;
    getCustomForm(userTask: UserTaskInstance, headers?: any): Promise<Form>;
    getTaskPhases(userTask: UserTaskInstance, headers?: any): Promise<string[]>;
}
//# sourceMappingURL=TaskFormGatewayApi.d.ts.map