import { getJobsWithFilters, handleJobReschedule, jobCancel, performMultipleCancel, } from "@kie-tools/runtime-tools-process-gateway-api/dist/gatewayApi";
export class GraphQLJobsManagementQueries {
    constructor(client) {
        this.client = client;
    }
    async getJobs(offset, limit, filters, orderBy) {
        return getJobsWithFilters(offset, limit, filters, orderBy, this.client);
    }
    async cancelJob(job) {
        return jobCancel(job, this.client);
    }
    async bulkCancel(jobsToBeActioned) {
        return performMultipleCancel(jobsToBeActioned, this.client);
    }
    async rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate) {
        return handleJobReschedule(job, repeatInterval, repeatLimit, scheduleDate, this.client);
    }
}
//# sourceMappingURL=JobsManagementQueries.js.map