import { EditorInitArgs, EditorTheme, KogitoEditorEnvelopeContextType } from "@kie-tools-core/editor/dist/api";
import { Notification } from "@kie-tools-core/notifications/dist/api";
import { DashbuilderEditorChannelApi } from "../api/DashbuilderEditorChannelApi";
import { DashbuilderEditorApi } from "../api/DashbuilderEditorApi";
import { Position } from "monaco-editor";
import { DashbuilderEditorEnvelopeApi } from "../api";
export declare class DashbuilderEditorView implements DashbuilderEditorApi {
    private readonly envelopeContext;
    private readonly initArgs;
    private readonly editorRef;
    af_isReact: boolean;
    af_componentId: "dashbuilder-editor";
    af_componentTitle: "Dashbuilder Editor";
    constructor(envelopeContext: KogitoEditorEnvelopeContextType<DashbuilderEditorEnvelopeApi, DashbuilderEditorChannelApi>, initArgs: EditorInitArgs);
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    getContent(): Promise<string>;
    getPreview(): Promise<string | undefined>;
    af_componentRoot(): JSX.Element;
    undo(): Promise<void>;
    redo(): Promise<void>;
    validate(): Promise<Notification[]>;
    setTheme(theme: EditorTheme): Promise<void>;
    moveCursorToPosition(position: Position): void;
}
//# sourceMappingURL=DashbuilderEditorView.d.ts.map