"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PopupMessagesNotificationHandler = void 0;
var vscode = require("vscode");
var PopupMessagesNotificationHandler = (function () {
    function PopupMessagesNotificationHandler(vscodeWorkspace, i18n) {
        this.vscodeWorkspace = vscodeWorkspace;
        this.i18n = i18n;
    }
    PopupMessagesNotificationHandler.prototype.createNotification = function (notification) {
        this.getHandleStrategyForSeverity(notification.severity)(notification.message, notification.normalizedPosixPathRelativeToTheWorkspaceRoot);
    };
    PopupMessagesNotificationHandler.prototype.showAlert = function (normalizedPosixPathRelativeToTheWorkspaceRoot, notifications) {
        if (notifications.length === 0) {
            return;
        }
        var errors = notifications.filter(function (n) { return n.severity === "ERROR"; });
        var others = notifications.filter(function (n) { return n.severity !== "ERROR"; });
        var errorsMessage = this.consolidateMessages(errors);
        var othersMessage = this.consolidateMessages(others);
        this.getHandleStrategyForSeverity("ERROR")(errorsMessage, normalizedPosixPathRelativeToTheWorkspaceRoot);
        this.getHandleStrategyForSeverity("SUCCESS")(othersMessage, normalizedPosixPathRelativeToTheWorkspaceRoot);
    };
    PopupMessagesNotificationHandler.prototype.getHandleStrategyForSeverity = function (severity) {
        switch (severity) {
            case "ERROR":
                return this.handleStrategy(vscode.window.showErrorMessage);
            case "WARNING":
                return this.handleStrategy(vscode.window.showWarningMessage);
            default:
                return this.handleStrategy(vscode.window.showInformationMessage);
        }
    };
    PopupMessagesNotificationHandler.prototype.handleStrategy = function (showFunction) {
        var _this = this;
        return function (message, normalizedPosixPathRelativeToTheWorkspaceRoot) {
            return normalizedPosixPathRelativeToTheWorkspaceRoot.length === 0
                ? showFunction(message)
                : showFunction(message, _this.i18n.getCurrent().open).then(function (selected) {
                    if (!selected) {
                        return;
                    }
                    _this.vscodeWorkspace.openFile(normalizedPosixPathRelativeToTheWorkspaceRoot);
                });
        };
    };
    PopupMessagesNotificationHandler.prototype.consolidateMessages = function (notifications) {
        var messages = notifications.map(function (n) { return n.message; });
        if (messages.length > 0) {
            return messages.reduce(function (accum, current) { return "".concat(accum, "\n").concat(current); });
        }
        else {
            return "";
        }
    };
    return PopupMessagesNotificationHandler;
}());
exports.PopupMessagesNotificationHandler = PopupMessagesNotificationHandler;
//# sourceMappingURL=PopupMessagesNotificationHandler.js.map