import { KIE_DMN_UNKNOWN_NAMESPACE } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { buildXmlHref, parseXmlHref, xmlHrefToQName } from "@kie-tools/dmn-marshaller/dist/xml";
import { snapShapeDimensions, snapShapePosition } from "../../diagram/SnapGrid";
import { EDGE_TYPES } from "../../diagram/edges/EdgeTypes";
import { getAdjMatrix, traverse } from "../../diagram/graph/graph";
import { getNodeTypeFromDmnObject } from "../../diagram/maths/DmnMaths";
import { DECISION_SERVICE_COLLAPSED_DIMENSIONS, MIN_NODE_SIZES } from "../../diagram/nodes/DefaultSizes";
import { ___NASTY_HACK_FOR_SAFARI_to_force_redrawing_svgs_and_avoid_repaint_glitches } from "../../diagram/nodes/NodeSvgs";
import { NODE_TYPES } from "../../diagram/nodes/NodeTypes";
import { getDecisionServicePropertiesRelativeToThisDmn } from "../../mutations/addExistingDecisionServiceToDrd";
import { KIE_UNKNOWN_NAMESPACE } from "../../kie/kie";
export const NODE_LAYERS = {
    GROUP_NODE: 0,
    NODES: 1000,
    DECISION_SERVICE_NODE: 2000,
    NESTED_NODES: 4000,
};
export function computeDiagramData(diagram, definitions, externalModelTypesByNamespace, indexedDrd, isAlternativeInputDataShape) {
    var _a, _b, _c, _d, _e;
    ___NASTY_HACK_FOR_SAFARI_to_force_redrawing_svgs_and_avoid_repaint_glitches.flag =
        !___NASTY_HACK_FOR_SAFARI_to_force_redrawing_svgs_and_avoid_repaint_glitches.flag;
    const drgElementsWithoutVisualRepresentationOnCurrentDrd = [];
    const selectedNodesById = new Map();
    const selectedEdgesById = new Map();
    const selectedNodeTypes = new Set();
    const nodesById = new Map();
    const edgesById = new Map();
    const parentIdsById = new Map();
    const externalNodesByNamespace = new Map();
    const edgesFromExternalNodesByNamespace = new Map();
    const { selectedNodes, draggingNodes, resizingNodes, selectedEdges } = {
        selectedNodes: new Set(diagram._selectedNodes),
        draggingNodes: new Set(diagram.draggingNodes),
        resizingNodes: new Set(diagram.resizingNodes),
        selectedEdges: new Set(diagram._selectedEdges),
    };
    const edges = [];
    const drgEdges = [];
    const drgAdjacencyList = new Map();
    const ackEdge = ({ id, type, dmnObject, source, target, sourceNamespace }) => {
        var _a;
        const data = {
            dmnObject,
            dmnEdge: id ? indexedDrd.dmnEdgesByDmnElementRef.get(xmlHrefToQName(id, definitions)) : undefined,
            dmnShapeSource: indexedDrd.dmnShapesByHref.get(source),
            dmnShapeTarget: indexedDrd.dmnShapesByHref.get(target),
        };
        const edge = {
            data,
            id,
            type,
            source,
            target,
            selected: selectedEdges.has(id),
        };
        if (sourceNamespace && sourceNamespace !== KIE_UNKNOWN_NAMESPACE) {
            edgesFromExternalNodesByNamespace.set(sourceNamespace, [
                ...((_a = edgesFromExternalNodesByNamespace.get(sourceNamespace)) !== null && _a !== void 0 ? _a : []),
                edge,
            ]);
        }
        edgesById.set(edge.id, edge);
        if (edge.selected) {
            selectedEdgesById.set(edge.id, edge);
        }
        edges.push(edge);
        drgEdges.push({ id, sourceId: source, targetId: target, dmnObject });
        const targetAdjancyList = drgAdjacencyList.get(target);
        if (!targetAdjancyList) {
            drgAdjacencyList.set(target, { dependencies: new Set([source]) });
        }
        else {
            targetAdjancyList.dependencies.add(source);
        }
        return edge;
    };
    ackRequirementEdges(definitions["@_namespace"], definitions["@_namespace"], definitions.drgElement, ackEdge);
    ((_a = definitions.artifact) !== null && _a !== void 0 ? _a : []).forEach((dmnObject, index) => {
        var _a, _b;
        if (dmnObject.__$$element !== "association") {
            return;
        }
        ackEdge({
            id: dmnObject["@_id"],
            dmnObject: {
                namespace: definitions["@_namespace"],
                type: dmnObject.__$$element,
                id: dmnObject["@_id"],
                requirementType: "association",
                index,
            },
            type: EDGE_TYPES.association,
            source: (_a = dmnObject.sourceRef) === null || _a === void 0 ? void 0 : _a["@_href"],
            target: (_b = dmnObject.targetRef) === null || _b === void 0 ? void 0 : _b["@_href"],
            sourceNamespace: undefined,
        });
    });
    const ackNode = (dmnObjectQName, dmnObject, index) => {
        var _a, _b;
        const type = getNodeTypeFromDmnObject(dmnObject);
        if (!type) {
            return undefined;
        }
        const dmnObjectNamespace = dmnObjectQName.prefix
            ? (_a = definitions[`@_xmlns:${dmnObjectQName.prefix}`]) !== null && _a !== void 0 ? _a : KIE_DMN_UNKNOWN_NAMESPACE
            : undefined;
        const id = buildXmlHref({ namespace: dmnObjectNamespace, id: dmnObjectQName.localPart });
        const _shape = indexedDrd.dmnShapesByHref.get(id);
        if (!_shape) {
            drgElementsWithoutVisualRepresentationOnCurrentDrd.push(id);
            return undefined;
        }
        const { dmnElementRefQName, ...shape } = _shape;
        const data = {
            dmnObjectNamespace,
            dmnObjectQName,
            dmnObject,
            shape,
            index,
            hasHiddenRequirements: false,
            parentRfNode: undefined,
        };
        const newNode = {
            id,
            type,
            selected: selectedNodes.has(id),
            dragging: draggingNodes.has(id),
            resizing: resizingNodes.has(id),
            position: snapShapePosition(diagram.snapGrid, shape),
            data,
            zIndex: NODE_LAYERS.NODES,
            style: {
                ...snapShapeDimensions(diagram.snapGrid, shape, MIN_NODE_SIZES[type]({ snapGrid: diagram.snapGrid, isAlternativeInputDataShape })),
            },
        };
        if ((dmnObject === null || dmnObject === void 0 ? void 0 : dmnObject.__$$element) === "decisionService") {
            if (!shape["@_isCollapsed"]) {
                const { containedDecisionHrefsRelativeToThisDmn } = getDecisionServicePropertiesRelativeToThisDmn({
                    thisDmnsNamespace: definitions["@_namespace"],
                    decisionServiceNamespace: dmnObjectNamespace !== null && dmnObjectNamespace !== void 0 ? dmnObjectNamespace : definitions["@_namespace"],
                    decisionService: dmnObject,
                });
                for (let i = 0; i < containedDecisionHrefsRelativeToThisDmn.length; i++) {
                    parentIdsById.set(containedDecisionHrefsRelativeToThisDmn[i], data);
                }
            }
            else {
                newNode.style = {
                    ...newNode.style,
                    ...DECISION_SERVICE_COLLAPSED_DIMENSIONS,
                };
            }
        }
        if (dmnObjectNamespace && dmnObjectNamespace !== KIE_UNKNOWN_NAMESPACE) {
            externalNodesByNamespace.set(dmnObjectNamespace, [
                ...((_b = externalNodesByNamespace.get(dmnObjectNamespace)) !== null && _b !== void 0 ? _b : []),
                newNode,
            ]);
        }
        nodesById.set(newNode.id, newNode);
        if (newNode.selected) {
            selectedNodesById.set(newNode.id, newNode);
            selectedNodeTypes.add(newNode.type);
        }
        return newNode;
    };
    const localNodes = [
        ...((_b = definitions.drgElement) !== null && _b !== void 0 ? _b : []).flatMap((dmnObject, index) => {
            const newNode = ackNode({ type: "xml-qname", localPart: dmnObject["@_id"] }, dmnObject, index);
            return newNode ? [newNode] : [];
        }),
        ...((_c = definitions.artifact) !== null && _c !== void 0 ? _c : []).flatMap((dmnObject, index) => {
            if (dmnObject.__$$element === "association") {
                return [];
            }
            const newNode = ackNode({ type: "xml-qname", localPart: dmnObject["@_id"] }, dmnObject, index);
            return newNode ? [newNode] : [];
        }),
    ];
    const externalDrgElementsByIdByNamespace = [...externalModelTypesByNamespace.dmns.entries()].reduce((acc, [namespace, externalDmn]) => {
        var _a;
        ackRequirementEdges(definitions["@_namespace"], externalDmn.model.definitions["@_namespace"], externalDmn.model.definitions.drgElement, ackEdge);
        return acc.set(namespace, ((_a = externalDmn.model.definitions.drgElement) !== null && _a !== void 0 ? _a : []).reduce((acc, e, index) => acc.set(e["@_id"], { element: e, index }), new Map()));
    }, new Map());
    const externalNodes = [...indexedDrd.dmnShapesByHref.entries()].flatMap(([href, shape]) => {
        if (nodesById.get(href)) {
            return [];
        }
        if (!nodesById.get(href) && !indexedDrd.hrefsOfDmnElementRefsOfShapesPointingToExternalDmnObjects.has(href)) {
            console.warn(`DMN DIAGRAM: Found a shape that references a local DRG element that doesn't exist.`, shape);
            const newNode = ackNode(shape.dmnElementRefQName, null, -1);
            return newNode ? [newNode] : [];
        }
        const namespace = definitions[`@_xmlns:${shape.dmnElementRefQName.prefix}`];
        if (!namespace) {
            console.warn(`DMN DIAGRAM: Found a shape that references an external node with a namespace that is not declared at this DMN.`, shape);
            const newNode = ackNode(shape.dmnElementRefQName, null, -1);
            return newNode ? [newNode] : [];
        }
        const externalDrgElementsById = externalDrgElementsByIdByNamespace.get(namespace);
        if (!externalDrgElementsById) {
            console.warn(`DMN DIAGRAM: Found a shape that references an external node from a namespace that is not provided on this DMN's external DMNs mapping.`, shape);
            const newNode = ackNode(shape.dmnElementRefQName, null, -1);
            return newNode ? [newNode] : [];
        }
        const externalDrgElement = externalDrgElementsById.get(shape.dmnElementRefQName.localPart);
        if (!externalDrgElement) {
            console.warn(`DMN DIAGRAM: Found a shape that references a non-existent node from an external DMN.`, shape);
            const newNode = ackNode(shape.dmnElementRefQName, null, -1);
            return newNode ? [newNode] : [];
        }
        const newNode = ackNode(shape.dmnElementRefQName, externalDrgElement.element, externalDrgElement.index);
        return newNode ? [newNode] : [];
    });
    const sortedNodes = [...localNodes, ...externalNodes]
        .sort((a, b) => Number(b.type === NODE_TYPES.decisionService) - Number(a.type === NODE_TYPES.decisionService))
        .sort((a, b) => Number(b.type === NODE_TYPES.group) - Number(a.type === NODE_TYPES.group));
    const sortedEdges = edges
        .filter((e) => nodesById.has(e.source) && nodesById.has(e.target))
        .sort((a, b) => Number(selectedEdges.has(a.id)) - Number(selectedEdges.has(b.id)));
    for (const node of sortedNodes) {
        for (const dependencyNodeId of (_e = (_d = drgAdjacencyList.get(node.id)) === null || _d === void 0 ? void 0 : _d.dependencies) !== null && _e !== void 0 ? _e : new Set()) {
            if (!nodesById.get(dependencyNodeId)) {
                node.data.hasHiddenRequirements = true;
                break;
            }
        }
    }
    if (diagram.overlays.enableNodeHierarchyHighlight) {
        assignClassesToHighlightedHierarchyNodes(diagram._selectedNodes, nodesById, edgesById, drgEdges);
    }
    for (let i = 0; i < sortedNodes.length; i++) {
        const parentNodeData = parentIdsById.get(sortedNodes[i].id);
        if (parentNodeData) {
            sortedNodes[i].data.parentRfNode = nodesById.get(buildXmlHref({
                namespace: parentNodeData.dmnObjectNamespace,
                id: parentNodeData.dmnObjectQName.localPart,
            }));
            sortedNodes[i].extent = undefined;
            sortedNodes[i].zIndex = NODE_LAYERS.NESTED_NODES;
        }
        if (sortedNodes[i].type === NODE_TYPES.group) {
            sortedNodes[i].zIndex = NODE_LAYERS.GROUP_NODE;
        }
        else if (sortedNodes[i].type === NODE_TYPES.decisionService) {
            sortedNodes[i].zIndex = NODE_LAYERS.DECISION_SERVICE_NODE;
        }
    }
    return {
        drgEdges,
        drgAdjacencyList,
        nodes: sortedNodes,
        edges: sortedEdges,
        edgesById,
        externalNodesByNamespace,
        edgesFromExternalNodesByNamespace,
        nodesById,
        selectedNodeTypes,
        selectedNodesById,
        selectedEdgesById,
        drgElementsWithoutVisualRepresentationOnCurrentDrd,
    };
}
function ackRequirementEdges(thisDmnsNamespace, drgElementsNamespace, drgElements, ackEdge) {
    var _a, _b, _c;
    const namespace = drgElementsNamespace === thisDmnsNamespace ? "" : drgElementsNamespace;
    for (const dmnObject of drgElements !== null && drgElements !== void 0 ? drgElements : []) {
        if (dmnObject.__$$element === "decision") {
            ((_a = dmnObject.informationRequirement) !== null && _a !== void 0 ? _a : []).forEach((ir, index) => {
                var _a, _b, _c;
                const irHref = parseXmlHref(((_a = ir.requiredDecision) !== null && _a !== void 0 ? _a : ir.requiredInput)["@_href"]);
                ackEdge({
                    id: drgElementsNamespace === thisDmnsNamespace
                        ? ir["@_id"]
                        : buildXmlHref({ namespace: drgElementsNamespace, id: ir["@_id"] }),
                    dmnObject: {
                        namespace: drgElementsNamespace,
                        type: dmnObject.__$$element,
                        id: dmnObject["@_id"],
                        requirementType: "informationRequirement",
                        index,
                    },
                    type: EDGE_TYPES.informationRequirement,
                    source: buildXmlHref({ namespace: (_b = irHref.namespace) !== null && _b !== void 0 ? _b : namespace, id: irHref.id }),
                    target: buildXmlHref({ namespace, id: dmnObject["@_id"] }),
                    sourceNamespace: (_c = irHref.namespace) !== null && _c !== void 0 ? _c : namespace,
                });
            });
        }
        if (dmnObject.__$$element === "decision" || dmnObject.__$$element === "businessKnowledgeModel") {
            ((_b = dmnObject.knowledgeRequirement) !== null && _b !== void 0 ? _b : []).forEach((kr, index) => {
                var _a, _b;
                const krHref = parseXmlHref(kr.requiredKnowledge["@_href"]);
                ackEdge({
                    id: drgElementsNamespace === thisDmnsNamespace
                        ? kr["@_id"]
                        : buildXmlHref({ namespace: drgElementsNamespace, id: kr["@_id"] }),
                    dmnObject: {
                        namespace: drgElementsNamespace,
                        type: dmnObject.__$$element,
                        id: dmnObject["@_id"],
                        requirementType: "knowledgeRequirement",
                        index,
                    },
                    type: EDGE_TYPES.knowledgeRequirement,
                    source: buildXmlHref({ namespace: (_a = krHref.namespace) !== null && _a !== void 0 ? _a : namespace, id: krHref.id }),
                    target: buildXmlHref({ namespace, id: dmnObject["@_id"] }),
                    sourceNamespace: (_b = krHref.namespace) !== null && _b !== void 0 ? _b : namespace,
                });
            });
        }
        if (dmnObject.__$$element === "decision" ||
            dmnObject.__$$element === "businessKnowledgeModel" ||
            dmnObject.__$$element === "knowledgeSource") {
            ((_c = dmnObject.authorityRequirement) !== null && _c !== void 0 ? _c : []).forEach((ar, index) => {
                var _a, _b, _c, _d;
                const arHref = parseXmlHref(((_b = (_a = ar.requiredInput) !== null && _a !== void 0 ? _a : ar.requiredDecision) !== null && _b !== void 0 ? _b : ar.requiredAuthority)["@_href"]);
                ackEdge({
                    id: ar["@_id"],
                    dmnObject: {
                        namespace: drgElementsNamespace,
                        type: dmnObject.__$$element,
                        id: dmnObject["@_id"],
                        requirementType: "authorityRequirement",
                        index,
                    },
                    type: EDGE_TYPES.authorityRequirement,
                    source: buildXmlHref({ namespace: (_c = arHref.namespace) !== null && _c !== void 0 ? _c : namespace, id: arHref.id }),
                    target: buildXmlHref({ namespace, id: dmnObject["@_id"] }),
                    sourceNamespace: (_d = arHref.namespace) !== null && _d !== void 0 ? _d : namespace,
                });
            });
        }
    }
}
export function assignClassesToHighlightedHierarchyNodes(selected, nodesById, edgesById, drgEdges) {
    const nodeVisitor = (nodeId, traversalDirection) => {
        const node = nodesById.get(nodeId);
        if (node) {
            node.className = `hierarchy ${traversalDirection}`;
        }
    };
    const edgeVisitor = (edge, traversalDirection) => {
        const rfEdge = edgesById.get(edge.id);
        if (rfEdge) {
            rfEdge.className = `hierarchy ${traversalDirection}`;
        }
    };
    const __selectedSet = new Set(selected);
    const __adjMatrix = getAdjMatrix(drgEdges);
    traverse(__adjMatrix, __selectedSet, selected, "up", nodeVisitor, edgeVisitor);
    traverse(__adjMatrix, __selectedSet, selected, "down", nodeVisitor, edgeVisitor);
}
//# sourceMappingURL=computeDiagramData.js.map