import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import { useState, useMemo, useCallback, useEffect, useRef } from "react";
import { FormGroup, FormSection } from "@patternfly/react-core/dist/js/components/Form";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { CubeIcon } from "@patternfly/react-icons/dist/js/icons/cube-icon";
import { PropertiesPanelHeader } from "./PropertiesPanelHeader";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { addOrGetDrd } from "../mutations/addOrGetDrd";
import { ArrowsAltVIcon } from "@patternfly/react-icons/dist/js/icons/arrows-alt-v-icon";
import { ArrowsAltHIcon } from "@patternfly/react-icons/dist/js/icons/arrows-alt-h-icon";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import UndoAltIcon from "@patternfly/react-icons/dist/js/icons/undo-alt-icon";
import { ColorPicker } from "./ColorPicker";
import { ToggleGroup, ToggleGroupItem } from "@patternfly/react-core/dist/js/components/ToggleGroup";
import "./ShapeOptions.css";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { MIN_NODE_SIZES } from "../diagram/nodes/DefaultSizes";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { useSettings } from "../settings/DmnEditorSettingsContext";
const DEFAULT_FILL_COLOR = { "@_blue": 255, "@_green": 255, "@_red": 255 };
const DEFAULT_STROKE_COLOR = { "@_blue": 0, "@_green": 0, "@_red": 0 };
export function ShapeOptions({ startExpanded, nodeIds, isDimensioningEnabled, isPositioningEnabled, }) {
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const { externalModelsByNamespace } = useExternalModels();
    const settings = useSettings();
    const shapes = useDmnEditorStore((s) => nodeIds.map((nodeId) => s.computed(s).indexedDrd().dmnShapesByHref.get(nodeId)));
    const nodesById = useDmnEditorStore((s) => s.computed(s).getDiagramData(externalModelsByNamespace).nodesById);
    const shapeStyles = useMemo(() => shapes.map((shape) => shape === null || shape === void 0 ? void 0 : shape["di:Style"]), [shapes]);
    const shapeBound = useMemo(() => { var _a; return (_a = shapes[0]) === null || _a === void 0 ? void 0 : _a["dc:Bounds"]; }, [shapes]);
    const boundWidth = useMemo(() => { var _a, _b; return +((_b = (_a = shapeBound === null || shapeBound === void 0 ? void 0 : shapeBound["@_width"]) === null || _a === void 0 ? void 0 : _a.toFixed(2)) !== null && _b !== void 0 ? _b : ""); }, [shapeBound]);
    const boundHeight = useMemo(() => { var _a, _b; return +((_b = (_a = shapeBound === null || shapeBound === void 0 ? void 0 : shapeBound["@_height"]) === null || _a === void 0 ? void 0 : _a.toFixed(2)) !== null && _b !== void 0 ? _b : ""); }, [shapeBound]);
    const boundPositionX = useMemo(() => { var _a, _b; return +((_b = (_a = shapeBound === null || shapeBound === void 0 ? void 0 : shapeBound["@_x"]) === null || _a === void 0 ? void 0 : _a.toFixed(2)) !== null && _b !== void 0 ? _b : ""); }, [shapeBound]);
    const boundPositionY = useMemo(() => { var _a, _b; return +((_b = (_a = shapeBound === null || shapeBound === void 0 ? void 0 : shapeBound["@_y"]) === null || _a === void 0 ? void 0 : _a.toFixed(2)) !== null && _b !== void 0 ? _b : ""); }, [shapeBound]);
    const [width, setWidth] = useState(boundWidth);
    const [height, setHeight] = useState(boundHeight);
    const previousNodeId = useRef(nodeIds[0]);
    useEffect(() => {
        setWidth(boundWidth);
        previousNodeId.current = nodeIds[0];
    }, [boundWidth, nodeIds]);
    useEffect(() => {
        setHeight(boundHeight);
        previousNodeId.current = nodeIds[0];
    }, [boundHeight, nodeIds]);
    const fillColor = useMemo(() => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        const b = ((_c = (_b = (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["dmndi:FillColor"]) === null || _b === void 0 ? void 0 : _b["@_blue"]) !== null && _c !== void 0 ? _c : DEFAULT_FILL_COLOR["@_blue"]).toString(16);
        const g = ((_f = (_e = (_d = shapeStyles[0]) === null || _d === void 0 ? void 0 : _d["dmndi:FillColor"]) === null || _e === void 0 ? void 0 : _e["@_green"]) !== null && _f !== void 0 ? _f : DEFAULT_FILL_COLOR["@_green"]).toString(16);
        const r = ((_j = (_h = (_g = shapeStyles[0]) === null || _g === void 0 ? void 0 : _g["dmndi:FillColor"]) === null || _h === void 0 ? void 0 : _h["@_red"]) !== null && _j !== void 0 ? _j : DEFAULT_FILL_COLOR["@_red"]).toString(16);
        return `#${r.length === 1 ? "0" + r : r}${g.length === 1 ? "0" + g : g}${b.length === 1 ? "0" + b : b}`;
    }, [shapeStyles]);
    const strokeColor = useMemo(() => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        const b = ((_c = (_b = (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["dmndi:StrokeColor"]) === null || _b === void 0 ? void 0 : _b["@_blue"]) !== null && _c !== void 0 ? _c : DEFAULT_STROKE_COLOR["@_blue"]).toString(16);
        const g = ((_f = (_e = (_d = shapeStyles[0]) === null || _d === void 0 ? void 0 : _d["dmndi:StrokeColor"]) === null || _e === void 0 ? void 0 : _e["@_green"]) !== null && _f !== void 0 ? _f : DEFAULT_STROKE_COLOR["@_green"]).toString(16);
        const r = ((_j = (_h = (_g = shapeStyles[0]) === null || _g === void 0 ? void 0 : _g["dmndi:StrokeColor"]) === null || _h === void 0 ? void 0 : _h["@_red"]) !== null && _j !== void 0 ? _j : DEFAULT_STROKE_COLOR["@_red"]).toString(16);
        return `#${r.length === 1 ? "0" + r : r}${g.length === 1 ? "0" + g : g}${b.length === 1 ? "0" + b : b}`;
    }, [shapeStyles]);
    const [isShapeSectionExpanded, setShapeSectionExpanded] = useState(startExpanded);
    const setBounds = useCallback((callback, nodeId) => {
        dmnEditorStoreApi.setState((s) => {
            var _a, _b, _c, _d, _e;
            const { diagramElements } = addOrGetDrd({
                definitions: s.dmn.model.definitions,
                drdIndex: s.computed(s).getDrdIndex(),
            });
            const index = (_d = (_c = (_b = (_a = s.computed(s).indexedDrd()) === null || _a === void 0 ? void 0 : _a.dmnShapesByHref) === null || _b === void 0 ? void 0 : _b.get(nodeId)) === null || _c === void 0 ? void 0 : _c.index) !== null && _d !== void 0 ? _d : -1;
            if (index < 0) {
                throw new Error(`DMN Shape for '${nodeId}' does not exist.`);
            }
            const shape = diagramElements === null || diagramElements === void 0 ? void 0 : diagramElements[index];
            if (shape.__$$element !== "dmndi:DMNShape") {
                throw new Error(`DMN Element with index ${index} is not a DMNShape.`);
            }
            (_e = shape["dc:Bounds"]) !== null && _e !== void 0 ? _e : (shape["dc:Bounds"] = { "@_height": 0, "@_width": 0, "@_x": 0, "@_y": 0 });
            callback(shape["dc:Bounds"], s);
        });
    }, [dmnEditorStoreApi]);
    const onChangeWidth = useCallback((newWidth) => {
        setWidth(+newWidth);
    }, []);
    const onBlurWidth = useCallback((event) => {
        setBounds((bounds, state) => {
            const node = nodesById.get(previousNodeId.current);
            const minNodeSize = MIN_NODE_SIZES[node === null || node === void 0 ? void 0 : node.type]({
                snapGrid: state.diagram.snapGrid,
                isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
            });
            if (parseInt(event.target.value) < minNodeSize["@_width"]) {
                bounds["@_width"] = minNodeSize["@_width"];
                setWidth(minNodeSize["@_width"]);
            }
            else {
                bounds["@_width"] = parseInt(event.target.value);
            }
        }, previousNodeId.current);
    }, [nodesById, setBounds]);
    const onChangeHeight = useCallback((newHeight) => {
        setHeight(+newHeight);
    }, []);
    const onBlurHeight = useCallback((event) => {
        setBounds((bounds, state) => {
            const node = nodesById.get(previousNodeId.current);
            const minNodeSize = MIN_NODE_SIZES[node === null || node === void 0 ? void 0 : node.type]({
                snapGrid: state.diagram.snapGrid,
                isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
            });
            if (parseInt(event.target.value) < minNodeSize["@_height"]) {
                bounds["@_height"] = minNodeSize["@_height"];
                setHeight(minNodeSize["@_height"]);
            }
            else {
                bounds["@_height"] = parseInt(event.target.value);
            }
        }, previousNodeId.current);
    }, [nodesById, setBounds]);
    const onChangePositionX = useCallback((newX) => {
        setBounds((bounds) => {
            bounds["@_x"] = +parseFloat(newX).toFixed(2);
        }, nodeIds[0]);
    }, [nodeIds, setBounds]);
    const onChangePositionY = useCallback((newY) => {
        setBounds((bounds) => {
            bounds["@_y"] = +parseFloat(newY).toFixed(2);
        }, nodeIds[0]);
    }, [nodeIds, setBounds]);
    const setShapeStyles = useCallback((callback) => {
        dmnEditorStoreApi.setState((s) => {
            var _a;
            const { diagramElements } = addOrGetDrd({
                definitions: s.dmn.model.definitions,
                drdIndex: s.computed(s).getDrdIndex(),
            });
            const shapesWithMinNodeSize = nodeIds.map((nodeId) => {
                const shape = s.computed(s).indexedDrd().dmnShapesByHref.get(nodeId);
                const node = s.computed(s).getDiagramData(externalModelsByNamespace).nodesById.get(nodeId);
                const minNodeSize = MIN_NODE_SIZES[node === null || node === void 0 ? void 0 : node.type]({
                    snapGrid: s.diagram.snapGrid,
                    isAlternativeInputDataShape: s.computed(s).isAlternativeInputDataShape(),
                });
                if (!shape) {
                    throw new Error(`DMN Shape for '${nodeId}' does not exist.`);
                }
                return { shape: diagramElements[shape.index], minNodeSize };
            });
            let i = 0;
            for (const { shape } of shapesWithMinNodeSize) {
                if (shape.__$$element !== "dmndi:DMNShape") {
                    throw new Error(`DMN Element with index ${i++} is not a DMNShape.`);
                }
                (_a = shape["di:Style"]) !== null && _a !== void 0 ? _a : (shape["di:Style"] = { "@_id": generateUuid(), __$$element: "dmndi:DMNStyle" });
            }
            callback(shapesWithMinNodeSize, s);
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace, nodeIds]);
    const [temporaryStrokeColor, setTemporaryStrokeColor] = useState();
    const onChangeStrokeColor = useCallback((newColor) => {
        setTemporaryStrokeColor(newColor.replace("#", ""));
        setShapeStyles((shapes, state) => {
            state.diagram.isEditingStyle = true;
        });
    }, [setShapeStyles]);
    useEffect(() => {
        const timeout = setTimeout(() => {
            if (!temporaryStrokeColor) {
                return;
            }
            setTemporaryStrokeColor(undefined);
            setShapeStyles((shapesWithMinNodeSize, state) => {
                shapesWithMinNodeSize.forEach(({ shape }) => {
                    var _a;
                    var _b;
                    state.diagram.isEditingStyle = false;
                    (_a = (_b = shape["di:Style"])["dmndi:StrokeColor"]) !== null && _a !== void 0 ? _a : (_b["dmndi:StrokeColor"] = { ...DEFAULT_STROKE_COLOR });
                    shape["di:Style"]["dmndi:StrokeColor"]["@_red"] = parseInt(temporaryStrokeColor.slice(0, 2), 16);
                    shape["di:Style"]["dmndi:StrokeColor"]["@_green"] = parseInt(temporaryStrokeColor.slice(2, 4), 16);
                    shape["di:Style"]["dmndi:StrokeColor"]["@_blue"] = parseInt(temporaryStrokeColor.slice(4, 6), 16);
                });
            });
        }, 0);
        return () => {
            clearTimeout(timeout);
        };
    }, [setShapeStyles, temporaryStrokeColor]);
    const [temporaryFillColor, setTemporaryFillColor] = useState();
    const onChangeFillColor = useCallback((newColor) => {
        setTemporaryFillColor(newColor.replace("#", ""));
        setShapeStyles((shapes, state) => {
            state.diagram.isEditingStyle = true;
        });
    }, [setShapeStyles]);
    useEffect(() => {
        const timeout = setTimeout(() => {
            if (!temporaryFillColor) {
                return;
            }
            setTemporaryFillColor(undefined);
            setShapeStyles((shapesWithMinNodeSize, state) => {
                shapesWithMinNodeSize.forEach(({ shape }) => {
                    var _a;
                    var _b;
                    state.diagram.isEditingStyle = false;
                    (_a = (_b = shape["di:Style"])["dmndi:FillColor"]) !== null && _a !== void 0 ? _a : (_b["dmndi:FillColor"] = { ...DEFAULT_FILL_COLOR });
                    shape["di:Style"]["dmndi:FillColor"]["@_red"] = parseInt(temporaryFillColor.slice(0, 2), 16);
                    shape["di:Style"]["dmndi:FillColor"]["@_green"] = parseInt(temporaryFillColor.slice(2, 4), 16);
                    shape["di:Style"]["dmndi:FillColor"]["@_blue"] = parseInt(temporaryFillColor.slice(4, 6), 16);
                });
            });
        }, 0);
        return () => {
            clearTimeout(timeout);
        };
    }, [setShapeStyles, temporaryFillColor]);
    const onReset = useCallback(() => {
        setShapeStyles((shapeWithNodes) => {
            shapeWithNodes.forEach(({ shape, minNodeSize }) => {
                var _a, _b;
                (_a = shape["di:Style"]) !== null && _a !== void 0 ? _a : (shape["di:Style"] = {
                    __$$element: "dmndi:DMNStyle",
                    "@_id": generateUuid(),
                    "dmndi:FillColor": { ...DEFAULT_FILL_COLOR },
                    "dmndi:StrokeColor": { ...DEFAULT_STROKE_COLOR },
                });
                shape["di:Style"]["dmndi:FillColor"] = { ...DEFAULT_FILL_COLOR };
                shape["di:Style"]["dmndi:StrokeColor"] = { ...DEFAULT_STROKE_COLOR };
                (_b = shape["dc:Bounds"]) !== null && _b !== void 0 ? _b : (shape["dc:Bounds"] = {
                    "@_width": minNodeSize["@_width"],
                    "@_height": minNodeSize["@_height"],
                    "@_x": 0,
                    "@_y": 0,
                });
                shape["dc:Bounds"]["@_width"] = minNodeSize["@_width"];
                shape["dc:Bounds"]["@_height"] = minNodeSize["@_height"];
            });
        });
    }, [setShapeStyles]);
    const strokeColorPickerRef = React.useRef(null);
    const fillColorPickerRef = React.useRef(null);
    return (_jsxs(_Fragment, { children: [_jsx(PropertiesPanelHeader, { icon: _jsx(CubeIcon, { width: 16, height: 36, style: { marginLeft: "12px" } }), expands: true, fixed: false, isSectionExpanded: isShapeSectionExpanded, toogleSectionExpanded: () => setShapeSectionExpanded((prev) => !prev), title: "Shape", action: _jsx(Button, { variant: ButtonVariant.plain, onClick: onReset, style: { paddingBottom: 0, paddingTop: 0 }, title: "Reset shape", isDisabled: settings.isReadOnly, children: _jsx(UndoAltIcon, {}) }) }), isShapeSectionExpanded && (_jsxs(FormSection, { style: { paddingLeft: "20px", marginTop: "0px", marginBottom: "16px" }, children: [_jsx(FormGroup, { label: "Style", children: _jsxs(ToggleGroup, { children: [_jsx(Tooltip, { content: "Fill color", children: _jsx(ToggleGroupItem, { className: "kie-dmn-editor--shape-options-toggle-button", text: _jsx(ColorPicker, { name: "shape-fill", icon: _jsx("div", { style: {
                                                    backgroundColor: fillColor,
                                                    width: "20px",
                                                    height: "20px",
                                                    border: "dashed 1px black",
                                                    marginBottom: "-6px",
                                                } }), color: fillColor, onChange: (newColor) => onChangeFillColor(newColor), colorPickerRef: fillColorPickerRef, isDisabled: settings.isReadOnly }), isDisabled: settings.isReadOnly, buttonId: "shape-style-toggle-group-fill-color", onClick: () => {
                                            var _a;
                                            (_a = fillColorPickerRef.current) === null || _a === void 0 ? void 0 : _a.click();
                                        } }, "fill-color") }), _jsx(Tooltip, { content: "Stroke color", children: _jsx(ToggleGroupItem, { className: "kie-dmn-editor--shape-options-toggle-button", text: _jsx(ColorPicker, { name: "shape-stroke", colorDisplay: _jsx("div", { style: {
                                                    backgroundColor: "transparent",
                                                    width: "20px",
                                                    height: "20px",
                                                    border: "solid 4px",
                                                    borderColor: strokeColor,
                                                    marginBottom: "-6px",
                                                } }), color: strokeColor, onChange: (newColor) => onChangeStrokeColor(newColor), colorPickerRef: strokeColorPickerRef, isDisabled: settings.isReadOnly }), isDisabled: settings.isReadOnly, buttonId: "shape-style-toggle-group-stroke-color", onClick: () => {
                                            var _a;
                                            (_a = strokeColorPickerRef.current) === null || _a === void 0 ? void 0 : _a.click();
                                        } }, "stroke-color") }), _jsx(Tooltip, { content: "Width", children: _jsx(ToggleGroupItem, { text: _jsxs("div", { style: {
                                                display: "flex",
                                                flexDirection: "row",
                                                alignItems: "center",
                                                justifyContent: "center",
                                                columnGap: "5px",
                                            }, children: [_jsx(TextInput, { "aria-label": "Width", "data-testid": "kie-tools--dmn-editor--properties-panel-node-shape-width-input", type: "number", isDisabled: isDimensioningEnabled ? false : true, value: isDimensioningEnabled ? width : undefined, placeholder: isDimensioningEnabled ? "Enter a value..." : undefined, onBlur: onBlurWidth, onChange: onChangeWidth, style: { border: "none", backgroundColor: "transparent" } }), _jsx("div", { children: _jsx(ArrowsAltHIcon, { "aria-label": "Width" }) })] }), isDisabled: settings.isReadOnly, buttonId: "shape-style-toggle-group-bound-width" }, "bound-width") }), _jsx(Tooltip, { content: "Height", children: _jsx(ToggleGroupItem, { text: _jsxs("div", { style: { display: "flex", flexDirection: "row", alignItems: "center", justifyContent: "center" }, children: [_jsx(TextInput, { "aria-label": "Height", "data-testid": "kie-tools--dmn-editor--properties-panel-node-shape-height-input", type: "number", isDisabled: isDimensioningEnabled ? false : true, value: isDimensioningEnabled ? height : undefined, placeholder: isDimensioningEnabled ? "Enter a value..." : undefined, onBlur: onBlurHeight, onChange: onChangeHeight, style: { border: "none", backgroundColor: "transparent" } }), _jsx("div", { children: _jsx(ArrowsAltVIcon, { "aria-label": "Height" }) })] }), isDisabled: settings.isReadOnly, buttonId: "shape-style-toggle-group-bound-height" }, "bound-height") })] }) }), isPositioningEnabled && (_jsx(FormGroup, { label: "Position", children: _jsxs("div", { style: {
                                display: "grid",
                                gridTemplateColumns: "auto auto auto auto",
                                gridTemplateRows: "auto",
                                gridTemplateAreas: `
                'position-x-label position-x-value position-y-label position-y-value'
            `,
                                columnGap: "5px",
                                alignItems: "center",
                            }, children: [_jsx("div", { style: { gridArea: "position-x-value" }, "data-testid": "kie-tools--dmn-editor--properties-panel-node-shape-x-input", children: _jsx(TextInput, { "aria-label": "X", type: "number", isDisabled: settings.isReadOnly, value: boundPositionX, onChange: onChangePositionX, placeholder: "Enter X value..." }) }), _jsx("div", { style: { gridArea: "position-x-label" }, children: _jsx("p", { children: "X" }) }), _jsx("div", { style: { gridArea: "position-y-value" }, "data-testid": "kie-tools--dmn-editor--properties-panel-node-shape-y-input", children: _jsx(TextInput, { "aria-label": "Y", type: "number", isDisabled: settings.isReadOnly, value: boundPositionY, onChange: onChangePositionY, placeholder: "Enter Y value..." }) }), _jsx("div", { style: { gridArea: "position-y-label" }, children: _jsx("p", { children: "Y" }) })] }) }))] }))] }));
}
//# sourceMappingURL=ShapeOptions.js.map