import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo } from "react";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { Truncate } from "@patternfly/react-core/dist/js/components/Truncate";
import { AngleDownIcon } from "@patternfly/react-icons/dist/js/icons/angle-down-icon";
import { AngleRightIcon } from "@patternfly/react-icons/dist/js/icons/angle-right-icon";
import "./PropertiesPanelHeader.css";
export function PropertiesPanelHeader(props) {
    const propertiesPanelHeaderClass = useMemo(() => {
        let className = "kie-dmn-editor--properties-panel-header";
        if (props.fixed) {
            className += " kie-dmn-editor--properties-panel-header-fixed";
        }
        else {
            className += " kie-dmn-editor--properties-panel-header-not-fixed";
        }
        if (props.fixed || !props.expands || !props.isSectionExpanded) {
            className += " kie-dmn-editor--properties-panel-header-border";
        }
        return className;
    }, [props.expands, props.fixed, props.isSectionExpanded]);
    return (_jsx("div", { className: propertiesPanelHeaderClass, children: _jsxs("div", { className: "kie-dmn-editor--properties-panel-header-items", children: [props.expands && (_jsx("div", { className: "kie-dmn-editor--properties-panel-header-toogle-expanded", children: _jsx(Button, { title: `Expand / collapse ${props.title}`, variant: ButtonVariant.plain, className: "kie-dmn-editor--documentation-link--row-expand-toogle", onClick: () => { var _a; return (_a = props.toogleSectionExpanded) === null || _a === void 0 ? void 0 : _a.call(props); }, children: (props.isSectionExpanded && _jsx(AngleDownIcon, {})) || _jsx(AngleRightIcon, {}) }) })), props.icon && _jsx("div", { className: "kie-dmn-editor--properties-panel-header-icon", children: props.icon }), _jsx("div", { className: "kie-dmn-editor--properties-panel-header-title", children: typeof props.title === "string" ? _jsx(Truncate, { content: props.title }) : props.title }), props.action && _jsx("div", { className: "kie-dmn-editor--properties-panel-header-action", children: props.action })] }) }));
}
//# sourceMappingURL=PropertiesPanelHeader.js.map