import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { useDmnEditorStoreApi } from "../store/StoreContext";
import { renameGroupNode } from "../mutations/renameNode";
import { useSettings } from "../settings/DmnEditorSettingsContext";
export function GroupProperties({ group, index }) {
    var _a;
    const { setState } = useDmnEditorStoreApi();
    const settings = useSettings();
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, { label: "Name", children: _jsx(TextInput, { "aria-label": "Name", type: "text", isDisabled: settings.isReadOnly, onChange: (newName) => {
                        setState((state) => {
                            renameGroupNode({
                                definitions: state.dmn.model.definitions,
                                index,
                                newName,
                            });
                        });
                    }, value: group["@_name"], placeholder: "Enter a name..." }) }), _jsx(FormGroup, { label: "Description", children: _jsx(TextArea, { "aria-label": "Description", type: "text", isDisabled: settings.isReadOnly, value: (_a = group.description) === null || _a === void 0 ? void 0 : _a.__$$text, onChange: (newDescription) => {
                        setState((state) => {
                            state.dmn.model.definitions.artifact[index].description = {
                                __$$text: newDescription,
                            };
                        });
                    }, placeholder: "Enter a description...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 }) }), _jsx(FormGroup, { label: "ID", children: _jsx(ClipboardCopy, { isReadOnly: true, hoverTip: "Copy", clickTip: "Copied", children: group["@_id"] }) })] }));
}
//# sourceMappingURL=GroupProperties.js.map