import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import { useMemo, useState, useCallback, useRef, useEffect } from "react";
import { Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Tooltip, TooltipPosition } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { PlusCircleIcon } from "@patternfly/react-icons/dist/js/icons/plus-circle-icon";
import { TimesIcon } from "@patternfly/react-icons/dist/js/icons/times-icon";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { AngleDownIcon } from "@patternfly/react-icons/dist/js/icons/angle-down-icon";
import { AngleRightIcon } from "@patternfly/react-icons/dist/js/icons/angle-right-icon";
import { InlineFeelNameInput, invalidInlineFeelNameStyle } from "../feel/InlineFeelNameInput";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { Draggable, DragAndDrop, useDraggableItemContext } from "../draggable/Draggable";
import "./DocumentationLinksFormGroup.css";
const PLACEHOLDER_URL_TITLE = "Enter a title...";
const PLACEHOLDER_URL = "https://...";
export function DocumentationLinksFormGroup({ isReadOnly, values, onChange, }) {
    var _a;
    const [autoFocusFirst, setAutoFocusFirst] = useState(true);
    const [valuesUuid, setValuesUuid] = useState((_a = (values !== null && values !== void 0 ? values : [])) === null || _a === void 0 ? void 0 : _a.map((_) => generateUuid()));
    const valuesCache = useRef(values !== null && values !== void 0 ? values : []);
    useEffect(() => {
        var _a;
        if (JSON.stringify(values) !== JSON.stringify(valuesCache.current)) {
            setValuesUuid((_a = (values !== null && values !== void 0 ? values : [])) === null || _a === void 0 ? void 0 : _a.map(() => generateUuid()));
            valuesCache.current = [...(values !== null && values !== void 0 ? values : [])];
        }
    }, [values]);
    const [expandedUrls, setExpandedUrls] = useState([]);
    const onInternalChange = useCallback((newValues) => {
        valuesCache.current = [...newValues];
        onChange === null || onChange === void 0 ? void 0 : onChange(newValues);
    }, [onChange]);
    const onAdd = useCallback(() => {
        setAutoFocusFirst(true);
        const newValues = [...(values !== null && values !== void 0 ? values : [])];
        newValues.unshift({ "@_name": "", "@_url": "" });
        setExpandedUrls((prev) => {
            const newUrlExpanded = [...prev];
            newUrlExpanded.unshift(true);
            return newUrlExpanded;
        });
        setValuesUuid((prev) => [generateUuid(), ...prev]);
        onInternalChange(newValues);
    }, [onInternalChange, values]);
    const onChangeKieAttachment = useCallback((args) => {
        var _a, _b, _c;
        setAutoFocusFirst(false);
        if (isReadOnly) {
            return;
        }
        const newValues = [...(values !== null && values !== void 0 ? values : [])];
        const newKieAttachment = (_a = newValues[args.index]) !== null && _a !== void 0 ? _a : { "@_name": "", "@_url": "" };
        newValues[args.index] = {
            "@_name": (_b = args.newUrlTitle) !== null && _b !== void 0 ? _b : newKieAttachment["@_name"],
            "@_url": (_c = args.newUrl) !== null && _c !== void 0 ? _c : newKieAttachment["@_url"],
        };
        onInternalChange(newValues);
    }, [isReadOnly, onInternalChange, values]);
    const onRemove = useCallback((index) => {
        setAutoFocusFirst(false);
        const newValues = [...(values !== null && values !== void 0 ? values : [])];
        newValues.splice(index, 1);
        setValuesUuid((prev) => {
            const newUuids = [...prev];
            newUuids.splice(index, 1);
            return newUuids;
        });
        setExpandedUrls((prev) => {
            const newUrlExpanded = [...prev];
            newUrlExpanded.splice(index, 1);
            return newUrlExpanded;
        });
        onInternalChange(newValues);
    }, [onInternalChange, values]);
    const setUrlExpanded = useCallback((isExpanded, index) => {
        setExpandedUrls((prev) => {
            const newUrlExpanded = [...prev];
            newUrlExpanded[index] = isExpanded;
            return newUrlExpanded;
        });
    }, []);
    const onDragEnd = useCallback((source, dest) => {
        const reordened = [...(values !== null && values !== void 0 ? values : [])];
        const [removed] = reordened.splice(source, 1);
        reordened.splice(dest, 0, removed);
        onInternalChange(reordened);
    }, [onInternalChange, values]);
    const reorder = useCallback((source, dest) => {
        setExpandedUrls((prev) => {
            const newUrlExpanded = [...prev];
            const [removed] = newUrlExpanded.splice(source, 1);
            newUrlExpanded.splice(dest, 0, removed);
            return newUrlExpanded;
        });
        setValuesUuid((prev) => {
            const reordenedUuid = [...prev];
            const [removedUuid] = reordenedUuid.splice(source, 1);
            reordenedUuid.splice(dest, 0, removedUuid);
            return reordenedUuid;
        });
    }, []);
    const draggableItem = useCallback((kieAttachment, index) => {
        var _a, _b, _c;
        return (_jsx(Draggable, { index: index, rowClassName: index !== 0 ? "kie-dmn-editor--documentation-link--not-first-element" : "", handlerStyle: expandedUrls[index]
                ? { alignSelf: "flex-start", paddingTop: "8px", paddingLeft: "16px", paddingRight: "16px" }
                : { paddingLeft: "16px", paddingRight: "16px" }, isDisabled: isReadOnly, children: _jsx("li", { children: _jsx(DocumentationLinksInput, { title: (_a = kieAttachment["@_name"]) !== null && _a !== void 0 ? _a : "", url: (_b = kieAttachment["@_url"]) !== null && _b !== void 0 ? _b : "", isReadOnly: isReadOnly, onChange: (newUrlTitle, newUrl) => onChangeKieAttachment({ newUrlTitle, newUrl, index }), onRemove: () => onRemove(index), isUrlExpanded: expandedUrls[index], setUrlExpanded: (isExpanded) => setUrlExpanded(isExpanded, index), autoFocus: autoFocusFirst ? index === 0 : false }) }) }, (_c = valuesUuid === null || valuesUuid === void 0 ? void 0 : valuesUuid[index]) !== null && _c !== void 0 ? _c : generateUuid()));
    }, [autoFocusFirst, expandedUrls, isReadOnly, onChangeKieAttachment, onRemove, setUrlExpanded, valuesUuid]);
    return (_jsx(FormGroup, { label: _jsxs("div", { style: { display: "flex", flexDirection: "row" }, children: [_jsx("label", { className: "pf-c-form__label", style: { flexGrow: 1, cursor: "auto" }, children: _jsx("span", { className: "pf-c-form__label-text", children: "Documentation links" }) }), !isReadOnly && (_jsx(Button, { variant: "plain", icon: _jsx(PlusCircleIcon, {}), onClick: onAdd, title: "Add documentation link" }))] }), children: _jsxs("ul", { children: [(values !== null && values !== void 0 ? values : []).length === 0 && (_jsx("li", { className: "kie-dmn-editor--documentation-link--empty-state", children: isReadOnly ? "None" : "None yet" })), _jsx(DragAndDrop, { reorder: reorder, onDragEnd: onDragEnd, values: values, draggableItem: draggableItem, isDisabled: isReadOnly })] }) }));
}
function DocumentationLinksInput({ title, url, isReadOnly, isUrlExpanded, onChange, onRemove, setUrlExpanded, autoFocus: parentAutoFocus, }) {
    const urlTitleRef = useRef(null);
    const uuid = useMemo(() => generateUuid(), []);
    const [titleIsUrl, setTitleIsUrl] = useState(false);
    const updatedOnToogle = useRef(false);
    const { hovered } = useDraggableItemContext();
    const [autoFocus, setAutoFocus] = useState(false);
    const parseUrl = useCallback((newUrl) => {
        try {
            const url = new URL(newUrl);
            return url.toString();
        }
        catch (error) {
            try {
                if (!newUrl.includes("http://") && !newUrl.includes("https://")) {
                    const urlWithProtocol = "https://" + newUrl + "/";
                    const url = new URL(urlWithProtocol);
                    return url.toString() === urlWithProtocol ? url.toString() : undefined;
                }
            }
            catch (error) {
                return undefined;
            }
            return undefined;
        }
    }, []);
    const toogleExpanded = useCallback((title, url) => {
        const parsedUrl = parseUrl(url);
        if (parsedUrl !== undefined && isUrlExpanded === true && (title === "" || titleIsUrl)) {
            setTitleIsUrl(true);
            updatedOnToogle.current = true;
            onChange(parsedUrl, parsedUrl);
            setUrlExpanded(false);
            setAutoFocus(false);
        }
        else if (parsedUrl !== undefined && parsedUrl !== url && isUrlExpanded === true) {
            updatedOnToogle.current = true;
            onChange(title, parsedUrl);
            setUrlExpanded(false);
            setAutoFocus(false);
        }
        else if (url !== "" && parsedUrl === undefined && title === "") {
            updatedOnToogle.current = true;
            onChange("", url);
        }
        else if (url !== "" && parsedUrl === undefined) {
        }
        else {
            setUrlExpanded(!isUrlExpanded);
            setAutoFocus(!isUrlExpanded);
        }
    }, [isUrlExpanded, titleIsUrl, parseUrl, setUrlExpanded, onChange]);
    const isUrl = useMemo(() => {
        try {
            return new URL(url) && !isUrlExpanded;
        }
        catch (error) {
            return false;
        }
    }, [url, isUrlExpanded]);
    const allUniqueNames = useMemo(() => new Map(), []);
    const validateTitle = useCallback((id, name, allUniqueNames) => true, []);
    const validateUrl = useCallback((id, url, allUniqueNames) => {
        if (url !== undefined && url !== "") {
            return parseUrl(url) !== undefined;
        }
        return true;
    }, [parseUrl]);
    const urlDescriptionTooltip = useMemo(() => {
        return url !== "" ? (_jsx(Text, { component: TextVariants.p, children: url })) : (_jsx(Text, { component: TextVariants.p, children: "Empty URL" }));
    }, [url]);
    const removeTooltip = useMemo(() => _jsx(Text, { component: TextVariants.p, children: "Remove" }), []);
    return (_jsx(React.Fragment, { children: _jsxs("div", { className: "kie-dmn-editor--documentation-link--row", "data-testid": "kie-tools--dmn-editor--documentation-link--row", children: [_jsx(Button, { title: "Expand / collapse documentation link", variant: ButtonVariant.plain, className: "kie-dmn-editor--documentation-link--row-expand-toogle", onClick: () => toogleExpanded(title, url), children: (isUrlExpanded && _jsx(AngleDownIcon, {})) || _jsx(AngleRightIcon, {}) }), _jsx("div", { className: "kie-dmn-editor--documentation-link--row-item", children: !isUrlExpanded ? (_jsxs(_Fragment, { children: [_jsx("div", { ref: urlTitleRef, className: "kie-dmn-editor--documentation-link--row-title", children: isUrl ? (_jsx("a", { href: url, target: "_blank", "data-testid": "kie-tools--dmn-editor--documentation-link--row-title", children: title })) : (_jsx("p", { style: title === "" ? {} : invalidInlineFeelNameStyle, onClick: () => setUrlExpanded(true), children: title !== "" ? title : PLACEHOLDER_URL_TITLE })) }), !isUrlExpanded && (_jsx(Tooltip, { content: urlDescriptionTooltip, position: TooltipPosition.topStart, reference: urlTitleRef }))] })) : (_jsxs("div", { className: "kie-dmn-editor--documentation-link--row-inputs", children: [_jsx(InlineFeelNameInput, { isPlain: true, isReadOnly: isReadOnly, id: `${uuid}-name`, shouldCommitOnBlur: true, placeholder: PLACEHOLDER_URL_TITLE, name: title !== null && title !== void 0 ? title : "", onRenamed: (newUrlTitle) => {
                                    if (!updatedOnToogle.current && newUrlTitle !== title) {
                                        onChange(newUrlTitle, url);
                                        setTitleIsUrl(false);
                                    }
                                    updatedOnToogle.current = false;
                                }, allUniqueNames: () => allUniqueNames, validate: validateTitle, autoFocus: parentAutoFocus || autoFocus, onKeyDown: (e) => {
                                    if (e.code === "Enter") {
                                        toogleExpanded(e.currentTarget.value, url);
                                    }
                                } }), _jsx(InlineFeelNameInput, { className: "kie-dmn-editor--documentation-link--row-inputs-url", isPlain: true, isReadOnly: isReadOnly, id: `${uuid}-url`, shouldCommitOnBlur: true, placeholder: PLACEHOLDER_URL, name: url !== null && url !== void 0 ? url : "", onRenamed: (newUrl) => {
                                    if (!updatedOnToogle.current && newUrl !== url) {
                                        onChange(title, newUrl);
                                    }
                                    updatedOnToogle.current = false;
                                }, allUniqueNames: () => allUniqueNames, validate: validateUrl, saveInvalidValue: true, onKeyDown: (e) => {
                                    if (e.code === "Enter") {
                                        toogleExpanded(title, e.currentTarget.value);
                                    }
                                } })] })) }), hovered && (_jsx(Tooltip, { content: removeTooltip, children: _jsx(Button, { title: "Remove documentation link", className: "kie-dmn-editor--documentation-link--row-remove", variant: "plain", icon: _jsx(TimesIcon, {}), isDisabled: isReadOnly, onClick: () => onRemove() }) }))] }) }));
}
//# sourceMappingURL=DocumentationLinksFormGroup.js.map