export function updateDrgElementType({ definitions, expression, drgElementIndex, }) {
    var _a, _b;
    const drgElement = (_a = definitions.drgElement) === null || _a === void 0 ? void 0 : _a[drgElementIndex];
    if (!drgElement) {
        throw new Error("DMN MUTATION: Can't update expression for drgElement that doesn't exist.");
    }
    if ((drgElement === null || drgElement === void 0 ? void 0 : drgElement.__$$element) === "decision") {
        drgElement.variable["@_typeRef"] = expression ? expression["@_typeRef"] : drgElement.variable["@_typeRef"];
    }
    else if ((drgElement === null || drgElement === void 0 ? void 0 : drgElement.__$$element) === "businessKnowledgeModel") {
        if (expression.__$$element !== "functionDefinition") {
            throw new Error("DMN MUTATION: Can't have an expression on a BKM that is not a Function.");
        }
        if (!(expression === null || expression === void 0 ? void 0 : expression.__$$element)) {
            throw new Error("DMN MUTATION: Can't determine expression type without its __$$element property.");
        }
        drgElement.variable["@_typeRef"] = (_b = expression === null || expression === void 0 ? void 0 : expression["@_typeRef"]) !== null && _b !== void 0 ? _b : drgElement.variable["@_typeRef"];
    }
    else {
        throw new Error("DMN MUTATION: Can't update expression for drgElement that is not a Decision or a BKM.");
    }
}
//# sourceMappingURL=updateDrgElementType.js.map