import { addOrGetDrd } from "./addOrGetDrd";
export function addEdgeWaypoint({ definitions, drdIndex, dmnEdgeIndex, beforeIndex, waypoint, }) {
    var _a, _b;
    const { diagramElements } = addOrGetDrd({ definitions, drdIndex });
    const diagramElement = diagramElements[dmnEdgeIndex];
    if (diagramElement.__$$element !== "dmndi:DMNEdge") {
        throw new Error("DMN MUTATION: Can't add a waypoint for an element that is not a DMNEdge.");
    }
    if (beforeIndex > ((_b = (_a = diagramElement["di:waypoint"]) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0) - 1) {
        throw new Error(`DMN MUTATION: Can't add waypoint before index '${beforeIndex}' to DMNEdge '${diagramElement["@_id"]}' because the waypoint array is smaller than 'beforeIndex' requires.`);
    }
    diagramElement["di:waypoint"].splice(beforeIndex, 0, waypoint);
}
//# sourceMappingURL=addEdgeWaypoint.js.map